<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model;

use Swoox\Api\Model\Manager;

/**
 * Class ManagerTest
 *
 * @package Tests\Swoox\Api\Model
 */
class ManagerTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Manager
     */
    private $manager;

    /**
     *
     */
    public function setUp()
    {

        $this->manager = new Manager(new \Swoox\Api\Api\Manager());
    }

    /**
     *
     */
    public function testRequest()
    {

        $responseFactory = $this->manager->request();

        $this->assertInstanceOf('Swoox\Api\Model\Request\Factory', $responseFactory);
    }

    /**
     *
     */
    public function testResponse()
    {

        $requestFactory = $this->manager->response();

        $this->assertInstanceOf('Swoox\Api\Model\Response\Factory', $requestFactory);
    }
}
