<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Index;

use Swoox\Api\Model\Request\Index\Factory;

/**
 * Class FactoryTest
 *
 * @package Tests\Swoox\Api\Model\Request\Index
 */
class FactoryTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var Factory
     */
    private $factory;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->factory = new Factory();
    }

    /**
     * testSwoox
     */
    public function testSwoox()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Index\Swoox\Request', $this->factory->swoox());
    }

    /**
     * testItem
     */
    public function testItem()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Index\Swoox\Item', $this->factory->item());
    }

    /**
     * testNameFieldList
     */
    public function testNameFieldList()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Index\Swoox\NameFieldList', $this->factory->nameFieldList());
    }

    /**
     * testValueItem
     */
    public function testValueItem()
    {

        $this->assertInstanceOf('Swoox\Api\Model\Request\Index\Swoox\Valueitem', $this->factory->valueItem());
    }
}
