<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Tests\Swoox\Api\Model\Request\Index\Swoox;

use JMS\Serializer\SerializerBuilder;
use Swoox\Api\Model\Request\Index\Swoox\UserData;

/**
 * Class UserDataTest
 *
 * @package Tests\Swoox\Api\Model\Request\Index\Swoox
 */
class UserDataTest extends \PHPUnit_Framework_TestCase
{

    /**
     * @var \JMS\Serializer\Serializer
     */
    protected $serializer;

    /**
     * setUp
     */
    public function setUp()
    {

        $this->serializer = SerializerBuilder::create()->build();
    }

    /**
     * testSerialize
     */
    public function testSerialize()
    {

        $jsonString = '{"ApiVersion":"1","AuthToken":"","ErrorLanguage":"en","ProjectId":"42","RefererURL":""}';

        $userData = new UserData();

        $this->assertEquals($jsonString, $this->serializer->serialize($userData, 'json'));
    }

    /**
     * testDeserialize
     */
    public function testDeserialize()
    {

        $xml = file_get_contents('Tests/data/Swoox/Api/Model/Request/Index/Swoox/userdata.xml', true);

        /**
         * @var \Swoox\Api\Model\Request\Index\Swoox\UserData $userData
         */
        $userData = $this->serializer->deserialize($xml, 'Swoox\Api\Model\Request\Index\Swoox\UserData', 'xml');

        $this->assertInstanceOf('\Swoox\Api\Model\Request\Index\Swoox\UserData', $userData);

        $this->assertEquals('1', $userData->getApiVersion());
        $this->assertEquals('xyz', $userData->getAuthToken());
        $this->assertEquals('en', $userData->getErrorLanguage());
        $this->assertEquals('42', $userData->getProjectId());
        $this->assertEquals('http://localhost', $userData->getRefererURL());
    }
}
