<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Request\Search\Interfaces;


interface RequestModelInterface
{

    /**
     * @param TypeInterface $datetime
     */
    public function addDateTime(TypeInterface $datetime);

    /**
     * @param TypeInterface $fallback
     */
    public function addFallback(TypeInterface $fallback);

    /**
     * @param TypeInterface $geopoint
     */
    public function addGeoPoint(TypeInterface $geopoint);

    /**
     * @param TypeInterface $geoshape
     */
    public function addGeoShape(TypeInterface $geoshape);

    /**
     * @param TypeInterface $multiselect
     */
    public function addMultiSelect(TypeInterface $multiselect);

    /**
     * @param TypeInterface $multivalue
     */
    public function addMultiValue(TypeInterface $multivalue);

    /**
     * @param TypeInterface $range
     */
    public function addRange(TypeInterface $range);

    /**
     * @param TypeInterface $value
     */
    public function addValue(TypeInterface $value);

    /**
     * @return TypeInterface[]
     */
    public function getDateTimes();

    /**
     * @return DefaultsInterface
     */
    public function getDefaults();

    /**
     * @return TypeInterface[]
     */
    public function getFallbacks();

    /**
     * @return TypeInterface[]
     */
    public function getGeoPoints();

    /**
     * @return TypeInterface[]
     */
    public function getGeoShapes();

    /**
     * @return TypeInterface[]
     */
    public function getMultiSelects();

    /**
     * @return TypeInterface[]
     */
    public function getMultiValues();

    /**
     * @return TypeInterface[]
     */
    public function getRanges();

    /**
     * @return TypeInterface[]
     */
    public function getValues();

    /**
     * @param DefaultsInterface $defaults
     */
    public function setDefaults(DefaultsInterface $defaults);

}
