<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2016 Lifestyle Webconsulting GmbH
 * @link      www.life-style.de
 */

namespace Swoox\Api\Model\Response\Search\Filter;

use JMS\Serializer\Annotation as Serializer;
use Swoox\Api\Model\Response\Search\Interfaces\BasicResponseModelInterface;
use Swoox\Api\Model\Response\Search\Interfaces\FilterResponseModelInterface;


/**
 * Class FilterResponse
 *
 * @package Swoox\Api\Model\Response\Search\Filter
 *
 * @Serializer\XmlRoot("FilterResponse")
 */
class FilterResponse implements BasicResponseModelInterface, FilterResponseModelInterface
{

    /**
     * @Serializer\SerializedName("ScriptSeconds")
     * @Serializer\Type("double")
     *
     * @var double
     */
    protected $scriptSeconds;


    /**
     * @Serializer\SerializedName("ResultsCount")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    protected $resultsCount;


    /**
     * @Serializer\SerializedName("Keywords")
     * @Serializer\Type("string")
     *
     * @var string
     */
    protected $keywords;


    /**
     * @Serializer\SerializedName("FilterHiddenArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterHiddenArray")
     *
     * @var FilterHiddenArray
     */
    protected $filterHiddenArray;


    /**
     * @Serializer\SerializedName("SelectedFilterArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\SelectedFilterArray")
     *
     * @var SelectedFilterArray
     */
    protected $selectedFilterArray;

    /**
     * @Serializer\SerializedName("FilterValueArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterValueArray")
     *
     * @var FilterValueArray
     */
    protected $filterValueArray;

    /**
     * @Serializer\SerializedName("FilterMultiSelectArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterMultiSelectArray")
     *
     * @var FilterMultiSelectArray
     */
    protected $filterMultiSelectArray;

    /**
     * @Serializer\SerializedName("FilterRangeArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterRangeArray")
     *
     * @var FilterRangeArray
     */
    protected $filterRangeArray;

    /**
     * @Serializer\SerializedName("FilterDistanceArray")
     * @Serializer\Type("Swoox\Api\Model\Response\Search\Filter\FilterDistanceArray")
     *
     * @var FilterRangeArray
     */
    protected $filterDistanceArray;


    /**
     * @return float
     */
    public function getScriptSeconds()
    {

        return $this->scriptSeconds;
    }

    /**
     * @param float $scriptSeconds
     *
     * @return FilterResponse
     */
    public function setScriptSeconds($scriptSeconds)
    {

        $this->scriptSeconds = $scriptSeconds;

        return $this;
    }

    /**
     * @return int
     */
    public function getResultsCount()
    {

        return $this->resultsCount;
    }

    /**
     * @param int $resultsCount
     *
     * @return FilterResponse
     */
    public function setResultsCount($resultsCount)
    {

        $this->resultsCount = $resultsCount;

        return $this;
    }

    /**
     * @return string
     */
    public function getKeywords()
    {

        return $this->keywords;
    }

    /**
     * @param string $keywords
     *
     * @return FilterResponse
     */
    public function setKeywords($keywords)
    {

        $this->keywords = $keywords;

        return $this;
    }

    /**
     * @return SelectedFilterArray
     */
    public function getSelectedFilterArray()
    {

        return $this->selectedFilterArray;
    }

    /**
     * @param SelectedFilterArray $selectedFilterArray
     *
     * @return FilterResponse
     */
    public function setSelectedFilterArray($selectedFilterArray)
    {

        $this->selectedFilterArray = $selectedFilterArray;

        return $this;
    }

    /**
     * @return FilterValueArray
     */
    public function getFilterValueArray()
    {

        return $this->filterValueArray;
    }

    /**
     * @param FilterValueArray $filterValueArray
     *
     * @return FilterResponse
     */
    public function setFilterValueArray($filterValueArray)
    {

        $this->filterValueArray = $filterValueArray;

        return $this;
    }

    /**
     * @return FilterMultiSelectArray
     */
    public function getFilterMultiSelectArray()
    {

        return $this->filterMultiSelectArray;
    }

    /**
     * @param FilterMultiSelectArray $filterMultiSelectArray
     *
     * @return FilterResponse
     */
    public function setFilterMultiSelectArray($filterMultiSelectArray)
    {

        $this->filterMultiSelectArray = $filterMultiSelectArray;

        return $this;
    }

    /**
     * @return FilterRangeArray
     */
    public function getFilterRangeArray()
    {

        return $this->filterRangeArray;
    }

    /**
     * @param FilterRangeArray $filterRangeArray
     *
     * @return FilterResponse
     */
    public function setFilterRangeArray($filterRangeArray)
    {

        $this->filterRangeArray = $filterRangeArray;

        return $this;
    }

    /**
     * @return FilterHiddenArray
     */
    public function getFilterHiddenArray()
    {

        return $this->filterHiddenArray;
    }

    /**
     * @param FilterHiddenArray $filterHiddenArray
     *
     * @return FilterResponse
     */
    public function setFilterHiddenArray($filterHiddenArray)
    {

        $this->filterHiddenArray = $filterHiddenArray;

        return $this;
    }

    /**
     * @return FilterRangeArray
     */
    public function getFilterDistanceArray()
    {

        return $this->filterDistanceArray;
    }

    /**
     * @param FilterRangeArray $filterDistanceArray
     *
     * @return FilterResponse
     */
    public function setFilterDistanceArray($filterDistanceArray)
    {

        $this->filterDistanceArray = $filterDistanceArray;

        return $this;
    }


}
