<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Message;

use JMS\Serializer\Annotation as Serializer;
use Vtours\Model\AbstractMessage;
use Vtours\Model\Agency;

/**
 * Class AgencyMessage
 * @package Vtours\Message
 */
class AgencyMessage extends AbstractMessage
{
    const EVENT_CREATE = "create";
    const EVENT_UPDATE = "update";
    const EVENT_DELETE = "delete";

    /**
     * @Serializer\Type("Vtours\Model\Agency")
     *
     * @var Agency
     */
    private $content;

    /**
     * @return Agency
     */
    public function getContent()
    {
        return $this->content;
    }

    /**
     * @param Agency $content
     */
    public function setContent($content)
    {
        $this->content = $content;
    }
}
