<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Agency
 * @package Vtours\Model
 */
class Agency
{
    /**
     * @var int
     */
    private $agencyNumber;

    /**
     * @var string
     */
    private $creditorNumber;

    /**
     * @var string
     */
    private $internalId;

    /**
     * @var string
     */
    private $shortName;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $cooperateForm;

    /**
     * @var string
     */
    private $street;

    /**
     * @var string
     */
    private $streetNumber;

    /**
     * @var string
     */
    private $addressAddition;

    /**
     * @var integer
     */
    private $zip;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $country;

    /**
     * @var string
     */
    private $website;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $phoneCountryPrefix;

    /**
     * @var string
     */
    private $phoneAreaCode;

    /**
     * @var string
     */
    private $phoneNumber;

    /**
     * @var boolean
     */
    private $phoneIsHotline;

    /**
     * @var string
     */
    private $faxCountryPrefix;

    /**
     * @var string
     */
    private $faxAreaCode;

    /**
     * @var string
     */
    private $faxNumber;

    /**
     * @var string
     */
    private $commercialRegister;

    /**
     * @var string
     */
    private $officeType;

    /**
     * @var int
     */
    private $employeeCount;

    /**
     * @var int
     */
    private $terminalCount;

    /**
     * @var int
     */
    private $foundationYear;

    /**
     * @var string
     */
    private $estimatedTurnover;

    /**
     * @var string
     */
    private $placeOfBusiness;

    /**
     * @var string
     */
    private $taxId;

    /**
     * @var string
     */
    private $agencyType;

    /**
     * @var string
     */
    private $spokenLanguage;

    /**
     * @var string
     */
    private $externalSalesManager;

    /**
     * @var string
     */
    private $potentialRating;

    /**
     * @var string
     */
    private $cluster;

    /**
     * @var string
     */
    private $internalComment;

    /**
     * @var bool
     */
    private $active;

    /**
     * @var bool
     */
    private $deleted;

    /**
     * @var \DateTime
     */
    private $creationDate;

    /**
     * @var \DateTime
     */
    private $changeDate;

    /**
     * @Serializer\Type("Vtours\Model\AgencyChain")
     *
     * @var AgencyChain
     */
    private $chain;

    /**
     * @Serializer\Type("Vtours\Model\AgencyPaymentDetails")
     *
     * @var AgencyPaymentDetails
     */
    private $paymentDetails;

    /**
     * @Serializer\Type("Vtours\Model\AgencyBookingChannelCollection")
     *
     * @var AgencyBookingChannelCollection
     */
    private $bookingChannels;

    /**
     * @param int $agencyNumber
     */
    public function __construct($agencyNumber)
    {
        $this->agencyNumber = $agencyNumber;
    }

    /**
     * @return int
     */
    public function getAgencyNumber()
    {
        return $this->agencyNumber;
    }

    /**
     * @return string
     */
    public function getCreditorNumber()
    {
        return $this->creditorNumber;
    }

    /**
     * @param string $creditorNumber
     * @return Agency
     */
    public function setCreditorNumber($creditorNumber)
    {
        $this->creditorNumber = $creditorNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getInternalId()
    {
        return $this->internalId;
    }

    /**
     * @param string $internalId
     * @return Agency
     */
    public function setInternalId($internalId)
    {
        $this->internalId = $internalId;
        return $this;
    }

    /**
     * @return string
     */
    public function getShortName()
    {
        return $this->shortName;
    }

    /**
     * @param string $shortName
     * @return Agency
     */
    public function setShortName($shortName)
    {
        $this->shortName = $shortName;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Agency
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getCooperateForm()
    {
        return $this->cooperateForm;
    }

    /**
     * @param string $cooperateForm
     * @return Agency
     */
    public function setCooperateForm($cooperateForm)
    {
        $this->cooperateForm = $cooperateForm;
        return $this;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @param string $street
     * @return Agency
     */
    public function setStreet($street)
    {
        $this->street = $street;
        return $this;
    }

    /**
     * @return string
     */
    public function getStreetNumber()
    {
        return $this->streetNumber;
    }

    /**
     * @param string $streetNumber
     * @return Agency
     */
    public function setStreetNumber($streetNumber)
    {
        $this->streetNumber = $streetNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getAddressAddition()
    {
        return $this->addressAddition;
    }

    /**
     * @param string $addressAddition
     * @return Agency
     */
    public function setAddressAddition($addressAddition)
    {
        $this->addressAddition = $addressAddition;
        return $this;
    }

    /**
     * @return int
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * @param int $zip
     * @return Agency
     */
    public function setZip($zip)
    {
        $this->zip = $zip;
        return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param string $city
     * @return Agency
     */
    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param string $country
     * @return Agency
     */
    public function setCountry($country)
    {
        $this->country = $country;
        return $this;
    }

    /**
     * @return string
     */
    public function getWebsite()
    {
        return $this->website;
    }

    /**
     * @param string $website
     * @return Agency
     */
    public function setWebsite($website)
    {
        $this->website = $website;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return Agency
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhoneCountryPrefix()
    {
        return $this->phoneCountryPrefix;
    }

    /**
     * @param string $phoneCountryPrefix
     * @return Agency
     */
    public function setPhoneCountryPrefix($phoneCountryPrefix)
    {
        $this->phoneCountryPrefix = $phoneCountryPrefix;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhoneAreaCode()
    {
        return $this->phoneAreaCode;
    }

    /**
     * @param string $phoneAreaCode
     * @return Agency
     */
    public function setPhoneAreaCode($phoneAreaCode)
    {
        $this->phoneAreaCode = $phoneAreaCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->phoneNumber;
    }

    /**
     * @param string $phoneNumber
     * @return Agency
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPhoneHotline()
    {
        return (bool)$this->phoneIsHotline;
    }

    /**
     * @param bool $phoneIsHotline
     * @return Agency
     */
    public function setPhoneIsHotline($phoneIsHotline)
    {
        $this->phoneIsHotline = $phoneIsHotline;
        return $this;
    }

    /**
     * @return string
     */
    public function getFaxCountryPrefix()
    {
        return $this->faxCountryPrefix;
    }

    /**
     * @param string $faxCountryPrefix
     * @return Agency
     */
    public function setFaxCountryPrefix($faxCountryPrefix)
    {
        $this->faxCountryPrefix = $faxCountryPrefix;
        return $this;
    }

    /**
     * @return string
     */
    public function getFaxAreaCode()
    {
        return $this->faxAreaCode;
    }

    /**
     * @param string $faxAreaCode
     * @return Agency
     */
    public function setFaxAreaCode($faxAreaCode)
    {
        $this->faxAreaCode = $faxAreaCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getFaxNumber()
    {
        return $this->faxNumber;
    }

    /**
     * @param string $faxNumber
     * @return Agency
     */
    public function setFaxNumber($faxNumber)
    {
        $this->faxNumber = $faxNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getCommercialRegister()
    {
        return $this->commercialRegister;
    }

    /**
     * @param string $commercialRegister
     * @return Agency
     */
    public function setCommercialRegister($commercialRegister)
    {
        $this->commercialRegister = $commercialRegister;
        return $this;
    }

    /**
     * @return string
     */
    public function getOfficeType()
    {
        return $this->officeType;
    }

    /**
     * @param string $officeType
     * @return Agency
     */
    public function setOfficeType($officeType)
    {
        $this->officeType = $officeType;
        return $this;
    }

    /**
     * @return int
     */
    public function getEmployeeCount()
    {
        return $this->employeeCount;
    }

    /**
     * @param int $employeeCount
     * @return Agency
     */
    public function setEmployeeCount($employeeCount)
    {
        $this->employeeCount = $employeeCount;
        return $this;
    }

    /**
     * @return int
     */
    public function getTerminalCount()
    {
        return $this->terminalCount;
    }

    /**
     * @param int $terminalCount
     * @return Agency
     */
    public function setTerminalCount($terminalCount)
    {
        $this->terminalCount = $terminalCount;
        return $this;
    }

    /**
     * @return int
     */
    public function getFoundationYear()
    {
        return $this->foundationYear;
    }

    /**
     * @param int $foundationYear
     * @return Agency
     */
    public function setFoundationYear($foundationYear)
    {
        $this->foundationYear = $foundationYear;
        return $this;
    }

    /**
     * @return string
     */
    public function getEstimatedTurnover()
    {
        return $this->estimatedTurnover;
    }

    /**
     * @param string $estimatedTurnover
     * @return Agency
     */
    public function setEstimatedTurnover($estimatedTurnover)
    {
        $this->estimatedTurnover = $estimatedTurnover;
        return $this;
    }

    /**
     * @return string
     */
    public function getPlaceOfBusiness()
    {
        return $this->placeOfBusiness;
    }

    /**
     * @param string $placeOfBusiness
     * @return Agency
     */
    public function setPlaceOfBusiness($placeOfBusiness)
    {
        $this->placeOfBusiness = $placeOfBusiness;
        return $this;
    }

    /**
     * @return string
     */
    public function getTaxId()
    {
        return $this->taxId;
    }

    /**
     * @param string $taxId
     * @return Agency
     */
    public function setTaxId($taxId)
    {
        $this->taxId = $taxId;
        return $this;
    }

    /**
     * @return string
     */
    public function getAgencyType()
    {
        return $this->agencyType;
    }

    /**
     * @param string $agencyType
     * @return Agency
     */
    public function setAgencyType($agencyType)
    {
        $this->agencyType = $agencyType;
        return $this;
    }

    /**
     * @return string
     */
    public function getSpokenLanguage()
    {
        return $this->spokenLanguage;
    }

    /**
     * @param string $spokenLanguage
     * @return Agency
     */
    public function setSpokenLanguage($spokenLanguage)
    {
        $this->spokenLanguage = $spokenLanguage;
        return $this;
    }

    /**
     * @return string
     */
    public function getExternalSalesManager()
    {
        return $this->externalSalesManager;
    }

    /**
     * @param string $externalSalesManager
     * @return Agency
     */
    public function setExternalSalesManager($externalSalesManager)
    {
        $this->externalSalesManager = $externalSalesManager;
        return $this;
    }

    /**
     * @return string
     */
    public function getPotentialRating()
    {
        return $this->potentialRating;
    }

    /**
     * @param string $potentialRating
     * @return Agency
     */
    public function setPotentialRating($potentialRating)
    {
        $this->potentialRating = $potentialRating;
        return $this;
    }

    /**
     * @return string
     */
    public function getCluster()
    {
        return $this->cluster;
    }

    /**
     * @param string $cluster
     * @return Agency
     */
    public function setCluster($cluster)
    {
        $this->cluster = $cluster;
        return $this;
    }

    /**
     * @return string
     */
    public function getInternalComment()
    {
        return $this->internalComment;
    }

    /**
     * @param string $internalComment
     * @return Agency
     */
    public function setInternalComment($internalComment)
    {
        $this->internalComment = $internalComment;
        return $this;
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return (bool)$this->active;
    }

    /**
     * @param bool $active
     * @return Agency
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDeleted()
    {
        return (bool)$this->deleted;
    }

    /**
     * @param bool $deleted
     * @return Agency
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreationDate()
    {
        return $this->creationDate;
    }

    /**
     * @param \DateTime $creationDate
     * @return Agency
     */
    public function setCreationDate($creationDate)
    {
        $this->creationDate = $creationDate;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getChangeDate()
    {
        return $this->changeDate;
    }

    /**
     * @param \DateTime $changeDate
     * @return Agency
     */
    public function setChangeDate($changeDate)
    {
        $this->changeDate = $changeDate;
        return $this;
    }

    /**
     * @return AgencyChain
     */
    public function getChain()
    {
        return $this->chain;
    }

    /**
     * @param AgencyChain $chain
     * @return Agency
     */
    public function setChain($chain)
    {
        $this->chain = $chain;
        return $this;
    }

    /**
     * @return AgencyPaymentDetails
     */
    public function getPaymentDetails()
    {
        return $this->paymentDetails;
    }

    /**
     * @param AgencyPaymentDetails $paymentDetails
     * @return Agency
     */
    public function setPaymentDetails($paymentDetails)
    {
        $this->paymentDetails = $paymentDetails;
        return $this;
    }

    /**
     * @return AgencyBookingChannelCollection
     */
    public function getBookingChannels()
    {
        return $this->bookingChannels;
    }

    /**
     * @param AgencyBookingChannelCollection $bookingChannels
     * @return Agency
     */
    public function setBookingChannels($bookingChannels)
    {
        $this->bookingChannels = $bookingChannels;
        return $this;
    }
}
