<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

/**
 * Class AgencyBookingChannel
 * @package Vtours\Model
 */
class AgencyBookingChannel
{
    /**
     * @var string
     */
    private $crs;
    /**
     * @var string
     */
    private $agencyNumber;
    /**
     * @var string
     */
    private $office;

    /**
     * @return string
     */
    public function getCrs()
    {
        return $this->crs;
    }

    /**
     * @param string $crs
     * @return AgencyBookingChannel
     */
    public function setCrs($crs)
    {
        $this->crs = $crs;
        return $this;
    }

    /**
     * @return string
     */
    public function getAgencyNumber()
    {
        return $this->agencyNumber;
    }

    /**
     * @param string $agencyNumber
     * @return AgencyBookingChannel
     */
    public function setAgencyNumber($agencyNumber)
    {
        $this->agencyNumber = $agencyNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getOffice()
    {
        return $this->office;
    }

    /**
     * @param string $office
     * @return AgencyBookingChannel
     */
    public function setOffice($office)
    {
        $this->office = $office;
        return $this;
    }

}
