<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

/**
 * Class AgencyUser
 * @package Vtours\Model
 */
class AgencyUser
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var bool
     */
    private $active;

    /**
     * @var bool
     */
    private $newsletterRecipient;

    /**
     * @var string
     */
    private $username;

    /**
     * @var integer
     */
    private $contactId;

    /**
     * @var string
     */
    private $rikEmail;

    /**
     * @var string
     */
    private $dikEmail;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return AgencyUser
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return bool
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param bool $active
     * @return AgencyUser
     */
    public function setActive($active)
    {
        $this->active = $active;
        return $this;
    }

    /**
     * @return bool
     */
    public function isNewsletterRecipient()
    {
        return $this->newsletterRecipient;
    }

    /**
     * @param bool $newsletterRecipient
     * @return AgencyUser
     */
    public function setNewsletterRecipient($newsletterRecipient)
    {
        $this->newsletterRecipient = $newsletterRecipient;
        return $this;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     * @return AgencyUser
     */
    public function setUsername($username)
    {
        $this->username = $username;
        return $this;
    }

    /**
     * @return int
     */
    public function getContactId()
    {
        return $this->contactId;
    }

    /**
     * @param int $contactId
     * @return AgencyUser
     */
    public function setContactId($contactId)
    {
        $this->contactId = $contactId;
        return $this;
    }

    /**
     * @return string
     */
    public function getRikEmail()
    {
        return $this->rikEmail;
    }

    /**
     * @param string $rikEmail
     * @return AgencyUser
     */
    public function setRikEmail($rikEmail)
    {
        $this->rikEmail = $rikEmail;
        return $this;
    }

    /**
     * @return string
     */
    public function getDikEmail()
    {
        return $this->dikEmail;
    }

    /**
     * @param string $dikEmail
     * @return AgencyUser
     */
    public function setDikEmail($dikEmail)
    {
        $this->dikEmail = $dikEmail;
        return $this;
    }
}
