<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Message\Test;

use PHPUnit\Framework\TestCase;
use Ramsey\Uuid\Uuid;
use Vtours\Message\AgencyMessage;
use Vtours\Model\Agency;

/**
 * Class MessageTest
 * @package Vtours\Message\Test
 */
class AgencyMessageTest extends TestCase
{

    public function test_correct_message_creation()
    {
        $correctMessage = new AgencyMessage(
            AgencyMessage::EVENT_CREATE,
            new Agency()
        );

        $this->assertInstanceOf(Agency::class, $correctMessage->getContent());
    }
}
