<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model;

/**
 * Class Agency
 * @package Vtours\Model
 */
class Agency
{
    /**
     * @var string
     */
    private $uuid;

    /**
     * @var int
     */
    private $agencyId;

    /**
     * @var string
     */
    private $internalId;

    /**
     * @var int
     */
    private $customerId;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $name2;

    /**
     * @var string
     */
    private $zip;

    /**
     * @var string
     */
    private $city;

    /**
     * @var string
     */
    private $street;

    /**
     * @var string
     */
    private $land;

    /**
     * @var string
     */
    private $phone;

    /**
     * @var string
     */
    private $email;

    /**
     * @var string
     */
    private $fax;

    /**
     * @var string
     */
    private $chain;

    /**
     * DIK or RIK
     *
     * @var string
     */
    private $cashingType;

    /**
     * @var string
     */
    private $bankName;

    /**
     * @var string
     */
    private $accountNumber;

    /**
     * @var string
     */
    private $accountHolder;

    /**
     * @var string
     */
    private $bankCode;

    /**
     * @var string
     */
    private $comment;

    /**
     * @var string
     */
    private $executive;

    /**
     * @var string
     */
    private $corporateForm;

    /**
     * @var string
     */
    private $tradeRegisterNumber;

    /**
     * @var string
     */
    private $taxNumber;

    /**
     * @var string
     */
    private $partnerName;

    /**
     * @var string
     */
    private $partnerPhone;

    /**
     * @var string
     */
    private $partnerMobile;

    /**
     * @var string
     */
    private $partnerEmail;

    /**
     * @var bool
     */
    private $locked;

    /**
     * @var bool
     */
    private $deleted;

    /**
     * VTO, VTOI, ...
     *
     * @var string
     */
    private $organizer;

    /**
     * @var \DateTime
     */
    private $created;

    /**
     * @var string
     */
    private $lastUpdatedFrom;

    public function __construct()
    {
        $this->uuid = \Ramsey\Uuid\Uuid::uuid4();
    }

    /**
     * @return \Ramsey\Uuid\UuidInterface|string
     */
    public function getUuid()
    {
        return $this->uuid;
    }

    /**
     * @return int
     */
    public function getAgencyId()
    {
        return $this->agencyId;
    }

    /**
     * @param int $agencyId
     * @return Agency
     */
    public function setAgencyId($agencyId)
    {
        $this->agencyId = $agencyId;
        return $this;
    }

    /**
     * @return string
     */
    public function getInternalId()
    {
        return $this->internalId;
    }

    /**
     * @param string $internalId
     * @return Agency
     */
    public function setInternalId($internalId)
    {
        $this->internalId = $internalId;
        return $this;
    }

    /**
     * @return int
     */
    public function getCustomerId()
    {
        return $this->customerId;
    }

    /**
     * @param int $customerId
     * @return Agency
     */
    public function setCustomerId($customerId)
    {
        $this->customerId = $customerId;
        return $this;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return Agency
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string
     */
    public function getName2()
    {
        return $this->name2;
    }

    /**
     * @param string $name2
     * @return Agency
     */
    public function setName2($name2)
    {
        $this->name2 = $name2;
        return $this;
    }

    /**
     * @return string
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * @param string $zip
     * @return Agency
     */
    public function setZip($zip)
    {
        $this->zip = $zip;
        return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param string $city
     * @return Agency
     */
    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @param string $street
     * @return Agency
     */
    public function setStreet($street)
    {
        $this->street = $street;
        return $this;
    }

    /**
     * @return string
     */
    public function getLand()
    {
        return $this->land;
    }

    /**
     * @param string $land
     * @return Agency
     */
    public function setLand($land)
    {
        $this->land = $land;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     * @return Agency
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return Agency
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }

    /**
     * @param string $fax
     * @return Agency
     */
    public function setFax($fax)
    {
        $this->fax = $fax;
        return $this;
    }

    /**
     * @return string
     */
    public function getChain()
    {
        return $this->chain;
    }

    /**
     * @param string $chain
     * @return Agency
     */
    public function setChain($chain)
    {
        $this->chain = $chain;
        return $this;
    }

    /**
     * @return string
     */
    public function getCashingType()
    {
        return $this->cashingType;
    }

    /**
     * @param string $cashingType
     * @return Agency
     */
    public function setCashingType($cashingType)
    {
        $this->cashingType = $cashingType;
        return $this;
    }

    /**
     * @return string
     */
    public function getBankName()
    {
        return $this->bankName;
    }

    /**
     * @param string $bankName
     * @return Agency
     */
    public function setBankName($bankName)
    {
        $this->bankName = $bankName;
        return $this;
    }

    /**
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }

    /**
     * @param string $accountNumber
     * @return Agency
     */
    public function setAccountNumber($accountNumber)
    {
        $this->accountNumber = $accountNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getAccountHolder()
    {
        return $this->accountHolder;
    }

    /**
     * @param string $accountHolder
     * @return Agency
     */
    public function setAccountHolder($accountHolder)
    {
        $this->accountHolder = $accountHolder;
        return $this;
    }

    /**
     * @return string
     */
    public function getBankCode()
    {
        return $this->bankCode;
    }

    /**
     * @param string $bankCode
     * @return Agency
     */
    public function setBankCode($bankCode)
    {
        $this->bankCode = $bankCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * @param string $comment
     * @return Agency
     */
    public function setComment($comment)
    {
        $this->comment = $comment;
        return $this;
    }

    /**
     * @return string
     */
    public function getExecutive()
    {
        return $this->executive;
    }

    /**
     * @param string $executive
     * @return Agency
     */
    public function setExecutive($executive)
    {
        $this->executive = $executive;
        return $this;
    }

    /**
     * @return string
     */
    public function getCorporateForm()
    {
        return $this->corporateForm;
    }

    /**
     * @param string $corporateForm
     * @return Agency
     */
    public function setCorporateForm($corporateForm)
    {
        $this->corporateForm = $corporateForm;
        return $this;
    }

    /**
     * @return string
     */
    public function getTradeRegisterNumber()
    {
        return $this->tradeRegisterNumber;
    }

    /**
     * @param string $tradeRegisterNumber
     * @return Agency
     */
    public function setTradeRegisterNumber($tradeRegisterNumber)
    {
        $this->tradeRegisterNumber = $tradeRegisterNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getTaxNumber()
    {
        return $this->taxNumber;
    }

    /**
     * @param string $taxNumber
     * @return Agency
     */
    public function setTaxNumber($taxNumber)
    {
        $this->taxNumber = $taxNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getPartnerName()
    {
        return $this->partnerName;
    }

    /**
     * @param string $partnerName
     * @return Agency
     */
    public function setPartnerName($partnerName)
    {
        $this->partnerName = $partnerName;
        return $this;
    }

    /**
     * @return string
     */
    public function getPartnerPhone()
    {
        return $this->partnerPhone;
    }

    /**
     * @param string $partnerPhone
     * @return Agency
     */
    public function setPartnerPhone($partnerPhone)
    {
        $this->partnerPhone = $partnerPhone;
        return $this;
    }

    /**
     * @return string
     */
    public function getPartnerMobile()
    {
        return $this->partnerMobile;
    }

    /**
     * @param string $partnerMobile
     * @return Agency
     */
    public function setPartnerMobile($partnerMobile)
    {
        $this->partnerMobile = $partnerMobile;
        return $this;
    }

    /**
     * @return string
     */
    public function getPartnerEmail()
    {
        return $this->partnerEmail;
    }

    /**
     * @param string $partnerEmail
     * @return Agency
     */
    public function setPartnerEmail($partnerEmail)
    {
        $this->partnerEmail = $partnerEmail;
        return $this;
    }

    /**
     * @return bool
     */
    public function isLocked()
    {
        return $this->locked;
    }

    /**
     * @param bool $locked
     * @return Agency
     */
    public function setLocked($locked)
    {
        $this->locked = $locked;
        return $this;
    }

    /**
     * @return bool
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param bool $deleted
     * @return Agency
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
        return $this;
    }

    /**
     * @return string
     */
    public function getOrganizer()
    {
        return $this->organizer;
    }

    /**
     * @param string $organizer
     * @return Agency
     */
    public function setOrganizer($organizer)
    {
        $this->organizer = $organizer;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * @param \DateTime $created
     * @return Agency
     */
    public function setCreated($created)
    {
        $this->created = $created;
        return $this;
    }

    /**
     * @return string
     */
    public function getLastUpdatedFrom()
    {
        return $this->lastUpdatedFrom;
    }

    /**
     * @param string $lastUpdatedFrom
     * @return Agency
     */
    public function setLastUpdatedFrom($lastUpdatedFrom)
    {
        $this->lastUpdatedFrom = $lastUpdatedFrom;
        return $this;
    }
}
