<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\BookingClassification\Service;

use Lifestyle\BookingClassification\Model\Classification;

/**
 * Class BookingClassificationService
 * @package Lifestyle\BookingClassification\Service
 */
class BookingClassificationService
{
    const PATTERN_VTO_OLD = [
        "pattern" => "/^2{1}[0-2]{1}[0-9]{4}$/",
        "client" => "VTO",
        "type" => null
    ];

    const PATTERN_VTO = [
        "pattern" => "/^1{1}[2-3]{1}[0-9]{6}$/",
        "client" => "VTO",
        "type" => null,
    ];

    const PATTERN_VTO_NEW = [
        "pattern" => "/^1{1}[2-3]{1}[0-9]{8}$/",
        "client" => "VTO",
        "type" => null,
    ];

    const PATTERN_ULTRA = [
        "pattern" => "/^5{1}[0-9]{7}$/",
        "client" => "ULTRA",
        "type" => null,
    ];

    const PATTERN_ULTRA_OLD = [
        "pattern" => "/^1{1}[0]{1}[0-9]{5}$/",
        "client" => "ULTRA",
        "type" => null,
    ];

    const PATTERN_VTOIDACH = [
        "pattern" => "/^3{1}[4-5]{1}[0-9]{6}$/",
        "client" => "VTOIDACH",
        "type" => null,
    ];

    const PATTERN_VTOIDACH_NEW = [
        "pattern" => "/^3{1}[4]{1}[0-9]{8}$/",
        "client" => "VTOIDACH",
        "type" => null,
    ];

    const PATTERN_VFLY_LINIE = [
        "pattern" => "/^2{1}[1-2]{1}[0-9]{6}$/",
        "client" => "VFLY",
        "type" => "LINIE",
    ];

    const PATTERN_VFLY_LINIE_NEW = [
        "pattern" => "/^2{1}[1-2]{1}[0-9]{8}$/",
        "client" => "VFLY",
        "type" => "LINIE",
    ];

    const PATTERN_VFLY_KONTI = [
        "pattern" => "/^1{1}[5-6]{1}[0-9]{6}$/",
        "client" => "VFLY",
        "type" => "KONTI",
    ];

    /**
     * @var array
     */
    public static $checkPatterns = [
        self::PATTERN_VTO,
        self::PATTERN_VTO_NEW,
        self::PATTERN_VTO_OLD,
        self::PATTERN_VFLY_KONTI,
        self::PATTERN_VFLY_LINIE,
        self::PATTERN_VFLY_LINIE_NEW,
        self::PATTERN_VTOIDACH,
        self::PATTERN_VTOIDACH_NEW,
        self::PATTERN_ULTRA,
        self::PATTERN_ULTRA_OLD,
    ];

    /**
     * @param integer $id
     * @return Classification
     */
    public static function classifyBookingByBookingNumber($id)
    {
        $classification = new Classification();

        array_walk(self::$checkPatterns, function ($classificationDefinition) use ($id, &$classification) {
            if (preg_match($classificationDefinition['pattern'], $id)) {
                $classification->setClient($classificationDefinition['client']);
                $classification->setCustomer(
                    !empty($classificationDefinition['type']) ?
                        $classificationDefinition['type'] :
                        null
                );
            }
        });

        return $classification;
    }
}
