<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2021 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

use Lifestyle\BookingClassification\Service\BookingClassificationService;
use PHPUnit\Framework\TestCase;

/**
 * Class BookingClassificationTests
 * @package Lifestyle\BookingClassification\Tests
 */
class BookingClassificationTests extends TestCase
{

    public function testVto()
    {
        $idsForTest = [
            204143,
            214146,
            224148,
            204150,
            214152,
            224154,
            204156,
            214158,
            224158,
            12175613,
            12347459,
            12147183,
            12247459,
            12332498,
            12347183,
            12347459,
            12347459,
            12347563,
            12347566,
            12447566,
            12547566,
            12647563,
            12747563,
            12847563,
            12947563,
            13071563,
            13171563,
            13271563,
            13371563,
            13471563,
            1300101109,
            1300101119,
            1300101129,
            1300101139,
        ];

        array_walk($idsForTest, function ($id) {
            $this->assertEquals(
                'VTO', (BookingClassificationService::classifyBookingByBookingNumber($id))->getClient()
            );
            $this->assertNull(
                (BookingClassificationService::classifyBookingByBookingNumber($id)->getCustomer())
            );
        });
    }

    public function testVtoidach()
    {
        $idsForTest = [
            34000062,
            34000011,
            34000007,
            34000012,
            34000025,
            34000026,
            34000036,
            34000017,
            34000038,
            34000039,
            34000040,
            34000065,
            34000072,
            34000013,
            34000018,
            34000019,
            34000023,
            34000022,
            3400004012,
            3400006513,
            3400007212,
            3400001313,
            3400001824,
            3400001912,
            3400002312,
            3400002233,
        ];

        array_walk($idsForTest, function ($id) {
            $this->assertEquals(
                'VTOIDACH', (BookingClassificationService::classifyBookingByBookingNumber($id))->getClient()
            );
            $this->assertNull(
                (BookingClassificationService::classifyBookingByBookingNumber($id)->getCustomer())
            );
        });
    }

    public function testVflyLinie()
    {
        $idsForTest = [
            21113673,
            21057756,
            21055855,
            21055856,
            21055857,
            21114444,
            21125966,
            21055852,
            21059931,
            21066094,
            21067686,
            21055859,
            21055860,
            21113683,
            21113684,
            21066622,
            21072927,
            21057015,
            21113685,
            21113686,
            21113687,
            2111367323,
            2105775623,
            2105585523,
            2105585623,
            2105585723,
            2111444423,
            2112596623,
            2105585223,
            2105993123,
            2106609423,
            2106768623,
            2105585923,
            2105586023,
            2111368323,
            2111368423,
            2106662223,
            2107292723,
            2105701523,
            2111368523,
            2111368623,
            2111368723,
        ];

        array_walk($idsForTest, function ($id) {
            $this->assertEquals(
                'VFLY', (BookingClassificationService::classifyBookingByBookingNumber($id))->getClient()
            );
            $this->assertEquals(
                'LINIE', (BookingClassificationService::classifyBookingByBookingNumber($id)->getCustomer())
            );
        });
    }

    public function testVflyKonti()
    {
        $idsForTest = [
            15883649,
            15883724,
            15883519,
            15883534,
            15883593,
            15883601,
            15883638,
            15883646,
            15883648,
            15883652,
            15883653,
            15883650,
            15883654,
            15883656,
            15883657,
            15883660,
            15883661,
            15883662,
            15883665,
            15883663,
            15883667,
            15883669,
            15883668,
            15883670
        ];

        array_walk($idsForTest, function ($id) {
            $this->assertEquals(
                'VFLY', (BookingClassificationService::classifyBookingByBookingNumber($id))->getClient()
            );
            $this->assertEquals(
                'KONTI', (BookingClassificationService::classifyBookingByBookingNumber($id)->getCustomer())
            );
        });
    }

    public function testUltra()
    {
        $idsForTest = [
            1000190,
            1000192,
            1000193,
            1000201,
            1000202,
            1000203,
            1000260,
            1000261,
            1000286,
            1000287,
            1000289,
            1000290,
            50013937,
            50010169,
            50010256,
            50010168,
            50010170,
            50053149,
            50053150,
            50010295,
            50368519,
            50010046,
            50010210,
            50010310,
            50321146,
            50010317,
            50010394,
        ];

        array_walk($idsForTest, function ($id) {
            $this->assertEquals(
                'ULTRA', (BookingClassificationService::classifyBookingByBookingNumber($id))->getClient()
            );
            $this->assertNull(
                (BookingClassificationService::classifyBookingByBookingNumber($id)->getCustomer())
            );
        });
    }
}