<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Agency;

/**
 * Trait AgencyBaseDataTrait
 * @package Vtours\Model\Booking\Agency
 */
trait AgencyBaseDataTrait
{
    /**
     * @var string
     */
    private $crs;

    /**
     * @var string
     */
    private $crsAgencyNumber;

    /**
     * @var string
     */
    private $crsDepartmentNumber;

    /**
     * @var string
     */
    private $reseller;

    /**
     * @return string
     */
    public function getCrs()
    {
        return $this->crs;
    }

    /**
     * @param string $crs
     * @return AgencyBaseDataTrait
     */
    public function setCrs($crs)
    {
        $this->crs = $crs;
        return $this;
    }

    /**
     * @return string
     */
    public function getCrsAgencyNumber()
    {
        return $this->crsAgencyNumber;
    }

    /**
     * @param string $crsAgencyNumber
     * @return AgencyBaseDataTrait
     */
    public function setCrsAgencyNumber($crsAgencyNumber)
    {
        $this->crsAgencyNumber = $crsAgencyNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getCrsDepartmentNumber()
    {
        return $this->crsDepartmentNumber;
    }

    /**
     * @param string $crsDepartmentNumber
     * @return AgencyBaseDataTrait
     */
    public function setCrsDepartmentNumber($crsDepartmentNumber)
    {
        $this->crsDepartmentNumber = $crsDepartmentNumber;
        return $this;
    }

    /**
     * @return string
     */
    public function getReseller()
    {
        return $this->reseller;
    }

    /**
     * @param string $reseller
     * @return AgencyBaseDataTrait
     */
    public function setReseller($reseller)
    {
        $this->reseller = $reseller;
        return $this;
    }
}
