<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking;


use JMS\Serializer\Annotation as Serializer;

/**
 * Trait BaseDataTrait
 * @package Vtours\Model\Booking
 */
trait BaseDataTrait
{
    /**
     * @var integer
     * @Serializer\Type("integer")
     */
    private $bookingId;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $client;

    /**
     * @var boolean
     * @Serializer\Type("boolean")
     */
    private $cancelled;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $bookingType;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $mappedBookingType;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $offerType;

    /**
     * @var \DateTime
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     */
    private $bookingDate;

    /**
     * @var \DateTime
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     */
    private $updateDate;

    /**
     * @var \DateTime
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     */
    private $travelBegin;

    /**
     * @var \DateTime
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     */
    private $travelEnd;

    /**
     * @var integer
     * @Serializer\Type("integer")
     */
    private $travelDuration;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $departureCode;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $destinationCode;

    /**
     * @var string
     */
    private $action;

    /**
     * @return integer
     */
    public function getBookingId()
    {
        return $this->bookingId;
    }

    /**
     * @param integer $bookingId
     * @return BaseDataTrait
     */
    public function setBookingId($bookingId)
    {
        $this->bookingId = $bookingId;
        return $this;
    }

    /**
     * @return string
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * @param string $client
     * @return BaseDataTrait
     */
    public function setClient($client)
    {
        $this->client = $client;
        return $this;
    }

    /**
     * @return bool
     */
    public function isCancelled()
    {
        return $this->cancelled;
    }

    /**
     * @param bool $cancelled
     * @return BaseDataTrait
     */
    public function setCancelled($cancelled)
    {
        $this->cancelled = $cancelled;
        return $this;
    }

    /**
     * @return string
     */
    public function getBookingType()
    {
        return $this->bookingType;
    }

    /**
     * @param string $bookingType
     * @return BaseDataTrait
     */
    public function setBookingType($bookingType)
    {
        $this->bookingType = $bookingType;
        return $this;
    }

    /**
     * @return string
     */
    public function getMappedBookingType()
    {
        return $this->mappedBookingType;
    }

    /**
     * @param string $mappedBookingType
     * @return BaseDataTrait
     */
    public function setMappedBookingType($mappedBookingType)
    {
        $this->mappedBookingType = $mappedBookingType;
        return $this;
    }

    /**
     * @return string
     */
    public function getOfferType()
    {
        return $this->offerType;
    }

    /**
     * @param string $offerType
     * @return BaseDataTrait
     */
    public function setOfferType($offerType)
    {
        $this->offerType = $offerType;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getBookingDate()
    {
        return $this->bookingDate;
    }

    /**
     * @param \DateTime $bookingDate
     * @return BaseDataTrait
     */
    public function setBookingDate($bookingDate)
    {
        $this->bookingDate = $bookingDate;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getUpdateDate()
    {
        return $this->updateDate;
    }

    /**
     * @param \DateTime $updateDate
     * @return BaseDataTrait
     */
    public function setUpdateDate($updateDate)
    {
        $this->updateDate = $updateDate;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTravelBegin()
    {
        return $this->travelBegin;
    }

    /**
     * @param \DateTime $travelBegin
     * @return BaseDataTrait
     */
    public function setTravelBegin($travelBegin)
    {
        $this->travelBegin = $travelBegin;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getTravelEnd()
    {
        return $this->travelEnd;
    }

    /**
     * @param \DateTime $travelEnd
     * @return BaseDataTrait
     */
    public function setTravelEnd($travelEnd)
    {
        $this->travelEnd = $travelEnd;
        return $this;
    }

    /**
     * @return integer
     */
    public function getTravelDuration()
    {
        return $this->travelDuration;
    }

    /**
     * @param integer $travelDuration
     * @return BaseDataTrait
     */
    public function setTravelDuration($travelDuration)
    {
        $this->travelDuration = $travelDuration;
        return $this;
    }

    /**
     * @return string
     */
    public function getDepartureCode()
    {
        return $this->departureCode;
    }

    /**
     * @param string $departureCode
     * @return BaseDataTrait
     */
    public function setDepartureCode($departureCode)
    {
        $this->departureCode = $departureCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getDestinationCode()
    {
        return $this->destinationCode;
    }

    /**
     * @param string $destinationCode
     * @return BaseDataTrait
     */
    public function setDestinationCode($destinationCode)
    {
        $this->destinationCode = $destinationCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * @param string $action
     * @return BaseDataTrait
     */
    public function setAction($action)
    {
        $this->action = $action;
        return $this;
    }

}
