<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking;

use Vtours\Model\Booking\Agency\Agency;
use Vtours\Model\Booking\Customer\Customer;
use Vtours\Model\Booking\Location\Location;
use Vtours\Model\Booking\Handling\Handling;
use Vtours\Model\Booking\Participant\Participant;
use Vtours\Model\Booking\Payment\Payments;
use Vtours\Model\Booking\Transfer\Transfer;
use Vtours\Model\Booking\TravelApplicant\TravelApplicant;

/**
 * Class Booking
 * @package Vtours\Model
 */
class Booking
{
    use BaseDataTrait;

    /**
     * @var TravelApplicant
     */
    private $travelApplicant;

    /**
     * @var Customer
     */
    private $customer;

    /**
     * @var Agency
     */
    private $agency;

    /**
     * @var Participant[]
     */
    private $participants;

    /**
     * @var Location
     */
    private $destination;

    /**
     * @var Location
     */
    private $departure;

    /**
     * @var Handling[]
     */
    private $handling;

    /**
     * @var Payments
     */
    private $payments;

    /**
     * @var Transfer
     */
    private $transfer;

    /**
     * @return TravelApplicant
     */
    public function getTravelApplicant()
    {
        return $this->travelApplicant;
    }

    /**
     * @param TravelApplicant $travelApplicant
     * @return Booking
     */
    public function setTravelApplicant(TravelApplicant $travelApplicant)
    {
        $this->travelApplicant = $travelApplicant;
        return $this;
    }

    /**
     * @return Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }

    /**
     * @param Customer $customer
     * @return Booking
     */
    public function setCustomer(Customer $customer)
    {
        $this->customer = $customer;
        return $this;
    }

    /**
     * @return Agency
     */
    public function getAgency()
    {
        return $this->agency;
    }

    /**
     * @param Agency $agency
     * @return Booking
     */
    public function setAgency(Agency $agency)
    {
        $this->agency = $agency;
        return $this;
    }

    /**
     * @return Participant[]
     */
    public function getParticipants()
    {
        return $this->participants;
    }

    /**
     * @param Participant $participant
     * @return Booking
     */
    public function addParticipant(Participant $participant)
    {
        $this->participants[] = $participant;
        return $this;
    }

    /**
     * @return Location
     */
    public function getDestination()
    {
        return $this->destination;
    }

    /**
     * @param Location $destination
     * @return Booking
     */
    public function setDestination(Location $destination)
    {
        $this->destination = $destination;
        return $this;
    }

    /**
     * @return Location
     */
    public function getDeparture()
    {
        return $this->departure;
    }

    /**
     * @param Location $departure
     * @return Booking
     */
    public function setDeparture(Location $departure)
    {
        $this->departure = $departure;
        return $this;
    }

    /**
     * @return Payments
     */
    public function getPayments()
    {
        return $this->payments;
    }

    /**
     * @param Payments $payments
     * @return Booking
     */
    public function setPayments(Payments $payments)
    {
        $this->payments = $payments;
        return $this;
    }

    /**
     * @return Handling[]
     */
    public function getHandling()
    {
        return $this->handling;
    }

    /**
     * @param Handling $handling
     * @return Booking
     */
    public function addHandling(Handling $handling)
    {
        $this->handling[] = $handling;
        return $this;
    }

    /**
     * @return Transfer
     */
    public function getTransfer()
    {
        return $this->transfer;
    }

    /**
     * @param Transfer $transfer
     * @return Booking
     */
    public function setTransfer(Transfer $transfer)
    {
        $this->transfer = $transfer;
        return $this;
    }

}
