<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Customer;

use JMS\Serializer\Annotation as Serializer;

/**
 * Trait CustomerTrait
 * @package Vtours\Model\Booking\Customer
 */
trait CustomerTrait
{
    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $salutation;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $firstName;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $lastName;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $street;

    /**
     * @var integer
     * @Serializer\Type("integer")
     */
    private $zip;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $city;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $country;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $phone;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $fax;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $mobile;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $email;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $language;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $emergencyMobileCountryCode;

    /**
     * @var int
     * @Serializer\Type("integer")
     */
    private $emergencyMobileCityCode;

    /**
     * @var int
     * @Serializer\Type("integer")
     */
    private $emergencyMobilePhoneNumber;

    /**
     * @var \DateTime
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     */
    private $emergencyMobileAddedDate;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $remarks;

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }

    /**
     * @param string $salutation
     * @return CustomerTrait
     */
    public function setSalutation($salutation)
    {
        $this->salutation = $salutation;
        return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return CustomerTrait
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
        return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     * @return CustomerTrait
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
        return $this;
    }

    /**
     * @return string
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * @param string $street
     * @return CustomerTrait
     */
    public function setStreet($street)
    {
        $this->street = $street;
        return $this;
    }

    /**
     * @return integer
     */
    public function getZip()
    {
        return $this->zip;
    }

    /**
     * @param integer $zip
     * @return CustomerTrait
     */
    public function setZip($zip)
    {
        $this->zip = $zip;
        return $this;
    }

    /**
     * @return string
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * @param string $city
     * @return CustomerTrait
     */
    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    /**
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * @param string $country
     * @return CustomerTrait
     */
    public function setCountry($country)
    {
        $this->country = $country;
        return $this;
    }

    /**
     * @return string
     */
    public function getPhone()
    {
        return $this->phone;
    }

    /**
     * @param string $phone
     * @return CustomerTrait
     */
    public function setPhone($phone)
    {
        $this->phone = $phone;
        return $this;
    }

    /**
     * @return string
     */
    public function getFax()
    {
        return $this->fax;
    }

    /**
     * @param string $fax
     * @return CustomerTrait
     */
    public function setFax($fax)
    {
        $this->fax = $fax;
        return $this;
    }

    /**
     * @return string
     */
    public function getMobile()
    {
        return $this->mobile;
    }

    /**
     * @param string $mobile
     * @return CustomerTrait
     */
    public function setMobile($mobile)
    {
        $this->mobile = $mobile;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return CustomerTrait
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * @param string $language
     * @return CustomerTrait
     */
    public function setLanguage($language)
    {
        $this->language = $language;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmergencyMobileCountryCode()
    {
        return $this->emergencyMobileCountryCode;
    }

    /**
     * @param string $emergencyMobileCountryCode
     * @return CustomerTrait
     */
    public function setEmergencyMobileCountryCode($emergencyMobileCountryCode)
    {
        $this->emergencyMobileCountryCode = $emergencyMobileCountryCode;
        return $this;
    }

    /**
     * @return int
     */
    public function getEmergencyMobileCityCode()
    {
        return $this->emergencyMobileCityCode;
    }

    /**
     * @param int $emergencyMobileCityCode
     * @return CustomerTrait
     */
    public function setEmergencyMobileCityCode($emergencyMobileCityCode)
    {
        $this->emergencyMobileCityCode = $emergencyMobileCityCode;
        return $this;
    }

    /**
     * @return int
     */
    public function getEmergencyMobilePhoneNumber()
    {
        return $this->emergencyMobilePhoneNumber;
    }

    /**
     * @param int $emergencyMobilePhoneNumber
     * @return CustomerTrait
     */
    public function setEmergencyMobilePhoneNumber($emergencyMobilePhoneNumber)
    {
        $this->emergencyMobilePhoneNumber = $emergencyMobilePhoneNumber;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getEmergencyMobileAddedDate()
    {
        return $this->emergencyMobileAddedDate;
    }

    /**
     * @param \DateTime $emergencyMobileAddedDate
     * @return CustomerTrait
     */
    public function setEmergencyMobileAddedDate($emergencyMobileAddedDate)
    {
        $this->emergencyMobileAddedDate = $emergencyMobileAddedDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getRemarks()
    {
        return $this->remarks;
    }

    /**
     * @param string $remarks
     * @return CustomerTrait
     */
    public function setRemarks($remarks)
    {
        $this->remarks = $remarks;
        return $this;
    }
}
