<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Handling;

use Vtours\Model\Booking\PriceHistory\PriceHistory;

/**
 * Class Handling
 * @package Vtours\Model\Booking\Handling
 */
class Handling
{
    use HandlingTrait;

    /**
     * @var PriceHistory[]
     */
    private $priceHistory;

    /**
     * @return PriceHistory[]
     */
    public function getPriceHistory()
    {
        return $this->priceHistory;
    }

    /**
     * @param PriceHistory $priceHistory
     * @return Handling
     */
    public function addPriceHistory(PriceHistory $priceHistory)
    {
        $this->priceHistory[] = $priceHistory;
        return $this;
    }


}
