<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Participant;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ParticipantsTrait
 * @package Vtours\Model\Booking\Participant
 */
trait ParticipantsTrait
{
    /**
     * @var Participant[]
     * @Serializer\Type("array<Vtours\Model\Booking\Participant\Participant>")
     */
    private $participants;


    /**
     * @return Participant[]
     */
    public function getParticipants()
    {
        return $this->participants;
    }

    /**
     * @param Participant $participant
     * @return ParticipantsTrait
     */
    public function addParticipant($participant)
    {
        $this->participants[] = $participant;
        return $this;
    }
}
