<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Payment\Details;

/**
 * Trait PaymentDetailsTrait
 * @package Vtours\Model\Booking\Payments
 */
trait PaymentDetailsTrait
{
    /**
     * @var string
     */
    private $type;

    /**
     * @var double
     */
    private $net;

    /**
     * @var double
     */
    private $vat;

    /**
     * @var double
     */
    private $gross;

    /**
     * @var double
     */
    private $payedAmount;

    /**
     * @var string
     */
    private $invoiceNumber;

    /**
     * @var \DateTime
     */
    private $date;

    /**
     * @var \DateTime
     */
    private $calculationDate;

    /**
     * @var \DateTime
     */
    private $paymentDate;

    /**
     * @var \DateTime
     */
    private $dueDate;

    /**
     * @var string
     */
    private $user;

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return PaymentDetailsTrait
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return float
     */
    public function getNet()
    {
        return $this->net;
    }

    /**
     * @param float $net
     * @return PaymentDetailsTrait
     */
    public function setNet($net)
    {
        $this->net = $net;
        return $this;
    }

    /**
     * @return float
     */
    public function getVat()
    {
        return $this->vat;
    }

    /**
     * @param float $vat
     * @return PaymentDetailsTrait
     */
    public function setVat($vat)
    {
        $this->vat = $vat;
        return $this;
    }

    /**
     * @return float
     */
    public function getGross()
    {
        return $this->gross;
    }

    /**
     * @param float $gross
     * @return PaymentDetailsTrait
     */
    public function setGross($gross)
    {
        $this->gross = $gross;
        return $this;
    }

    /**
     * @return float
     */
    public function getPayedAmount()
    {
        return $this->payedAmount;
    }

    /**
     * @param float $payedAmount
     * @return PaymentDetailsTrait
     */
    public function setPayedAmount($payedAmount)
    {
        $this->payedAmount = $payedAmount;
        return $this;
    }

    /**
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }

    /**
     * @param string $invoiceNumber
     * @return PaymentDetailsTrait
     */
    public function setInvoiceNumber($invoiceNumber)
    {
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     * @return PaymentDetailsTrait
     */
    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCalculationDate()
    {
        return $this->calculationDate;
    }

    /**
     * @param \DateTime $calculationDate
     * @return PaymentDetailsTrait
     */
    public function setCalculationDate($calculationDate)
    {
        $this->calculationDate = $calculationDate;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getPaymentDate()
    {
        return $this->paymentDate;
    }

    /**
     * @param \DateTime $paymentDate
     * @return PaymentDetailsTrait
     */
    public function setPaymentDate($paymentDate)
    {
        $this->paymentDate = $paymentDate;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }

    /**
     * @param \DateTime $dueDate
     * @return PaymentDetailsTrait
     */
    public function setDueDate($dueDate)
    {
        $this->dueDate = $dueDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @param string $user
     * @return PaymentDetailsTrait
     */
    public function setUser($user)
    {
        $this->user = $user;
        return $this;
    }
}
