<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Payment\Invoice;

/**
 * Trait InvoiceTrait
 * @package Vtours\Model\Booking\Payments\Invoice
 */
trait InvoiceTrait
{
    /**
     * @var string
     */
    private $number;

    /**
     * @var double
     */
    private $net;

    /**
     * @var double
     */
    private $vat;

    /**
     * @var double
     */
    private $gross;

    /**
     * @var \DateTime
     */
    private $date;

    /**
     * @var string
     */
    private $curency;

    /**
     * @var boolean
     */
    private $payed;

    /**
     * @var string
     */
    private $remarks;

    /**
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * @param string $number
     * @return InvoiceTrait
     */
    public function setNumber($number)
    {
        $this->number = $number;
        return $this;
    }

    /**
     * @return float
     */
    public function getNet()
    {
        return $this->net;
    }

    /**
     * @param float $net
     * @return InvoiceTrait
     */
    public function setNet($net)
    {
        $this->net = $net;
        return $this;
    }

    /**
     * @return float
     */
    public function getVat()
    {
        return $this->vat;
    }

    /**
     * @param float $vat
     * @return InvoiceTrait
     */
    public function setVat($vat)
    {
        $this->vat = $vat;
        return $this;
    }

    /**
     * @return float
     */
    public function getGross()
    {
        return $this->gross;
    }

    /**
     * @param float $gross
     * @return InvoiceTrait
     */
    public function setGross($gross)
    {
        $this->gross = $gross;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * @param \DateTime $date
     * @return InvoiceTrait
     */
    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurency()
    {
        return $this->curency;
    }

    /**
     * @param string $curency
     * @return InvoiceTrait
     */
    public function setCurency($curency)
    {
        $this->curency = $curency;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPayed()
    {
        return $this->payed;
    }

    /**
     * @param bool $payed
     * @return InvoiceTrait
     */
    public function setPayed($payed)
    {
        $this->payed = $payed;
        return $this;
    }

    /**
     * @return string
     */
    public function getRemarks()
    {
        return $this->remarks;
    }

    /**
     * @param string $remarks
     * @return InvoiceTrait
     */
    public function setRemarks($remarks)
    {
        $this->remarks = $remarks;
        return $this;
    }
}
