<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Payment;

use Vtours\Model\Booking\Payment\BankAccount\BankAccount;
use Vtours\Model\Booking\Payment\Details\PaymentDetails;
use Vtours\Model\Booking\Payment\Paycode\Paycode;
use Vtours\Model\Booking\Payment\Wirecard\Wirecard;
use Vtours\Model\Booking\PriceHistory\PriceHistory;

/**
 * Class Payments
 * @package Vtours\Model\Booking\Payments
 */
class Payments
{
    use PaymentBaseDataTrait;
    /**
     * @var PaymentDetails[]
     */
    private $paymentDetails;

    /**
     * @var PriceHistory[]
     */
    private $priceHistory;

    /**
     * @var BankAccount
     */
    private $bankAccount;

    /**
     * @var Paycode
     */
    private $paycode;

    /**
     * @var Wirecard
     */
    private $wirecard;

    /**
     * @return PaymentDetails[]
     */
    public function getPaymentDetails()
    {
        return $this->paymentDetails;
    }

    /**
     * @param PaymentDetails $paymentDetails
     * @return Payments
     */
    public function addPaymentDetails(PaymentDetails $paymentDetails)
    {
        $this->paymentDetails[] = $paymentDetails;
        return $this;
    }

    /**
     * @return PriceHistory[]
     */
    public function getPriceHistory()
    {
        return $this->priceHistory;
    }

    /**
     * @param PriceHistory $priceHistory
     * @return Payments
     */
    public function addPriceHistory(PriceHistory $priceHistory)
    {
        $this->priceHistory[] = $priceHistory;
        return $this;
    }

    /**
     * @return BankAccount
     */
    public function getBankAccount()
    {
        return $this->bankAccount;
    }

    /**
     * @param BankAccount $bankAccount
     * @return Payments
     */
    public function setBankAccount(BankAccount $bankAccount)
    {
        $this->bankAccount = $bankAccount;
        return $this;
    }

    /**
     * @return Paycode
     */
    public function getPaycode()
    {
        return $this->paycode;
    }

    /**
     * @param Paycode $paycode
     * @return Payments
     */
    public function setPaycode(Paycode $paycode)
    {
        $this->paycode = $paycode;
        return $this;
    }

    /**
     * @return Wirecard
     */
    public function getWirecard()
    {
        return $this->wirecard;
    }

    /**
     * @param Wirecard $wirecard
     * @return Payments
     */
    public function setWirecard(Wirecard $wirecard)
    {
        $this->wirecard = $wirecard;
        return $this;
    }

}
