<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Transfer;

use Vtours\Model\Booking\Payment\Invoice\Invoice;
use Vtours\Model\Booking\PriceHistory\PriceHistory;

/**
 * Class Transfer
 * @package Vtours\Model\Booking\Transfer
 */
class Transfer
{
    use TransferBaseDataTrait;

    /**
     * @var Invoice
     */
    private $invoice;

    /**
     * @var Invoice
     */
    private $cancellation;

    /**
     * @var PriceHistory[]
     */
    private $priceHistory;

    /**
     * @return Invoice
     */
    public function getInvoice()
    {
        return $this->invoice;
    }

    /**
     * @param Invoice $invoice
     * @return Transfer
     */
    public function setInvoice(Invoice $invoice)
    {
        $this->invoice = $invoice;
        return $this;
    }

    /**
     * @return Invoice
     */
    public function getCancellation()
    {
        return $this->cancellation;
    }

    /**
     * @param Invoice $cancellation
     * @return Transfer
     */
    public function setCancellation(Invoice $cancellation)
    {
        $this->cancellation = $cancellation;
        return $this;
    }

    /**
     * @return PriceHistory[]
     */
    public function getPriceHistory()
    {
        return $this->priceHistory;
    }

    /**
     * @param PriceHistory $priceHistory
     * @return Transfer
     */
    public function addPriceHistory(PriceHistory $priceHistory)
    {
        $this->priceHistory[] = $priceHistory;
        return $this;
    }

}
