<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Transfer;

/**
 * Trait TransferBaseDataTrait
 * @package Vtours\Model\Booking\Transfer
 */
trait TransferBaseDataTrait
{
    /**
     * @var string
     */
    private $agency;

    /**
     * @var string
     */
    private $creditorAccount;

    /**
     * @var \DateTime
     */
    private $dueDate;

    /**
     * @var double
     */
    private $baseAmount;

    /**
     * @var double
     */
    private $currentAmount;

    /**
     * @var double
     */
    private $totalAmount;

    /**
     * @var double
     */
    private $exchangeRate;

    /**
     * @var string
     */
    private $currency;

    /**
     * @var \DateTime
     */
    private $currentDate;

    /**
     * @var double
     */
    private $minimumRegulation;

    /**
     * @return string
     */
    public function getAgency()
    {
        return $this->agency;
    }

    /**
     * @param string $agency
     * @return TransferBaseDataTrait
     */
    public function setAgency($agency)
    {
        $this->agency = $agency;
        return $this;
    }

    /**
     * @return string
     */
    public function getCreditorAccount()
    {
        return $this->creditorAccount;
    }

    /**
     * @param string $creditorAccount
     * @return TransferBaseDataTrait
     */
    public function setCreditorAccount($creditorAccount)
    {
        $this->creditorAccount = $creditorAccount;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }

    /**
     * @param \DateTime $dueDate
     * @return TransferBaseDataTrait
     */
    public function setDueDate($dueDate)
    {
        $this->dueDate = $dueDate;
        return $this;
    }

    /**
     * @return float
     */
    public function getBaseAmount()
    {
        return $this->baseAmount;
    }

    /**
     * @param float $baseAmount
     * @return TransferBaseDataTrait
     */
    public function setBaseAmount($baseAmount)
    {
        $this->baseAmount = $baseAmount;
        return $this;
    }

    /**
     * @return float
     */
    public function getCurrentAmount()
    {
        return $this->currentAmount;
    }

    /**
     * @param float $currentAmount
     * @return TransferBaseDataTrait
     */
    public function setCurrentAmount($currentAmount)
    {
        $this->currentAmount = $currentAmount;
        return $this;
    }

    /**
     * @return float
     */
    public function getTotalAmount()
    {
        return $this->totalAmount;
    }

    /**
     * @param float $totalAmount
     * @return TransferBaseDataTrait
     */
    public function setTotalAmount($totalAmount)
    {
        $this->totalAmount = $totalAmount;
        return $this;
    }

    /**
     * @return float
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }

    /**
     * @param float $exchangeRate
     * @return TransferBaseDataTrait
     */
    public function setExchangeRate($exchangeRate)
    {
        $this->exchangeRate = $exchangeRate;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return TransferBaseDataTrait
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getCurrentDate()
    {
        return $this->currentDate;
    }

    /**
     * @param \DateTime $currentDate
     * @return TransferBaseDataTrait
     */
    public function setCurrentDate($currentDate)
    {
        $this->currentDate = $currentDate;
        return $this;
    }

    /**
     * @return float
     */
    public function getMinimumRegulation()
    {
        return $this->minimumRegulation;
    }

    /**
     * @param float $minimumRegulation
     * @return TransferBaseDataTrait
     */
    public function setMinimumRegulation($minimumRegulation)
    {
        $this->minimumRegulation = $minimumRegulation;
        return $this;
    }
}
