<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Test;

use PHPUnit\Framework\TestCase;
use Vtours\Model\Booking\Agency\Agency;
use Vtours\Model\Booking\Agency\BookedAgency\BookedAgency;
use Vtours\Model\Booking\Agency\BookingChannel\BookingChannel;
use Vtours\Model\Booking\Booking;

/**
 * Class AgencyTest
 * @package Vtours\Model\Booking\Test
 */
class AgencyTest extends TestCase
{
    public function test_add_booking_channel_to_agency_model()
    {
        $bookingChannel = new BookingChannel();
        $bookingChannel
            ->setAgency(124)
            ->setId(1)
            ->setChannel('Test Channel')
            ->setDepartment(001)
            ;

        $agency = new Agency();
        $agency->setBookingChannel($bookingChannel);

        self::assertSame('Test Channel', $agency->getBookingChannel()->getChannel());
    }

    public function test_add_booked_agency_to_agency_model()
    {
        $bookedAgency = new BookedAgency();
        $bookedAgency
            ->setName('Test Agency')
            ->setCity('Aschaffenburg')
        ;

        $agency = new Agency();
        $agency->setBookedAgency($bookedAgency);

        self::assertSame('Test Agency', $agency->getBookedAgency()->getName());
    }

    public function test_add_agency_model_to_booking_model()
    {
        $agency = new Agency();
        $agency->setBookedAgency(new BookedAgency());
        $agency->setBookingChannel(new BookingChannel());

        $booking = new Booking();
        $booking->setAgency($agency);

        self::assertInstanceOf(BookedAgency::class, $booking->getAgency()->getBookedAgency());
        self::assertInstanceOf(BookingChannel::class, $booking->getAgency()->getBookingChannel());
    }
}
