<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Test;

use PHPUnit\Framework\TestCase;
use Vtours\Model\Booking\Booking;
use Vtours\Model\Booking\Handling\Handling;

/**
 * Class HandlingTest
 * @package Vtours\Model\Booking\Test
 */
class HandlingTest extends TestCase
{
    public function test_add_handling_to_booking()
    {
        $handling1 = new Handling();
        $handling1
            ->setType('handling1')
            ->setAgency('NovumAYT')
            ->setTotalPrice(123)
            ->setCurrency('EUR')
            ->setInvoiceDate(new \DateTime())
            ->setActualPriceAmount(150)
        ;

        $handling2 = new Handling();
        $handling2
            ->setType('handling2')
            ->setAgency('NSU')
            ->setTotalPrice(250)
            ->setCurrency('USD')
            ->setInvoiceDate(new \DateTime())
            ->setActualPriceAmount(200)
        ;

        $booking = new Booking();
        $booking->addHandling($handling1);
        $booking->addHandling($handling2);

        self::assertCount(2, $booking->getHandling());
        self::assertSame('USD', $booking->getHandling()[1]->getCurrency());
    }
}
