<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Test;

use PHPUnit\Framework\TestCase;
use Vtours\Model\Booking\Booking;
use Vtours\Model\Booking\Location\Location;

/**
 * Class LocationTest
 * @package Vtours\Model\Booking\Test
 */
class LocationTest extends TestCase
{
    public function test_add_destination_model_to_booking_model()
    {
        $location = new Location();
        $location
            ->setCode('AYT')
            ->setName('Antalya')
            ;

        $booking = new Booking();
        $booking
            ->setDestination($location)
            ->setDeparture($location)
            ;

        self::assertInstanceOf(Location::class, $booking->getDestination());
        self::assertInstanceOf(Location::class, $booking->getDeparture());
        self::assertSame('Antalya', $booking->getDestination()->getName());
        self::assertSame('Antalya', $booking->getDeparture()->getName());
    }
}
