<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Test;

use PHPUnit\Framework\TestCase;
use Vtours\Model\Booking\Booking;
use Vtours\Model\Booking\Participant\Participant;

/**
 * Class ParticipantTest
 * @package Vtours\Model\Booking\Test
 */
class ParticipantTest extends TestCase
{
    public function test_add_participants_to_booking_model()
    {
        $participant1 = new Participant();
        $participant1
            ->setFirstName('Dennis')
            ->setLastName('Barlowe')
            ->setAge(24)
            ->setHandicapped(false)
            ->setPregnant(false)
        ;

        $participant2 = new Participant();
        $participant2
            ->setFirstName('Cedrik')
            ->setLastName('Bohrmann')
            ->setAge(25)
            ->setHandicapped(true)
            ->setPregnant(true)
        ;

        $booking = new Booking();
        $booking->addParticipant($participant1);
        $booking->addParticipant($participant2);

        self::assertCount(2, $booking->getParticipants());
        self::assertSame(25, $booking->getParticipants()[1]->getAge());

    }
}
