<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Test;

use PHPUnit\Framework\TestCase;
use Vtours\Model\Booking\PriceHistory\PriceHistory;

/**
 * Class PriceHistoryTest
 * @package Vtours\Model\Booking\Test
 */
class PriceHistoryTest extends TestCase
{
    public function test_create_price_history()
    {
        $priceHistory = new PriceHistory();
        $priceHistory->setPriceAfter(123);

        self::assertInstanceOf(PriceHistory::class, $priceHistory);
        self::assertSame(123, $priceHistory->getPriceAfter());
    }
}
