<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Test;

use PHPUnit\Framework\TestCase;
use Vtours\Model\Booking\Booking;
use Vtours\Model\Booking\Transfer\Transfer;

/**
 * Class TransferTest
 * @package Vtours\Model\Booking\Test
 */
class TransferTest extends TestCase
{
    public function test_add_transfer_to_booking_model()
    {
        $transfer = new Transfer();
        $transfer
            ->setAgency('NOVUM')
            ->setCurrentDate(new \DateTime());

        $booking = new Booking();
        $booking->setTransfer($transfer);

        self::assertInstanceOf(Transfer::class, $booking->getTransfer());
        self::assertSame('NOVUM', $booking->getTransfer()->getAgency());
    }
}
