<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Agency;

use Vtours\Model\Booking\Agency\BookedAgency\BookedAgency;
use Vtours\Model\Booking\Agency\BookingChannel\BookingChannel;

/**
 * Class Agency
 * @package Vtours\Model\Booking\Agency
 */
class Agency
{
    use AgencyBaseDataTrait;

    /**
     * @var BookedAgency
     */
    private $bookedAgency;

    /**
     * @var BookingChannel
     */
    private $bookingChannel;

    /**
     * @return BookedAgency
     */
    public function getBookedAgency()
    {
        return $this->bookedAgency;
    }

    /**
     * @param BookedAgency $bookedAgency
     * @return Agency
     */
    public function setBookedAgency(BookedAgency $bookedAgency)
    {
        $this->bookedAgency = $bookedAgency;
        return $this;
    }

    /**
     * @return BookingChannel
     */
    public function getBookingChannel()
    {
        return $this->bookingChannel;
    }

    /**
     * @param BookingChannel $bookingChannel
     * @return Agency
     */
    public function setBookingChannel(BookingChannel $bookingChannel)
    {
        $this->bookingChannel = $bookingChannel;
        return $this;
    }
}
