<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Agency\BookingChannel;

/**
 * Trait BookingChannelTrait
 * @package Vtours\Model\Booking\Agency\BookingChannel
 */
trait BookingChannelTrait
{
    /**
     * @var integer
     */
    private $id;

    /**
     * @var string
     */
    private $channel;

    /**
     * @var integer
     */
    private $agency;

    /**
     * @var integer
     */
    private $department;

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @param int $id
     * @return BookingChannelTrait
     */
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * @param string $channel
     * @return BookingChannelTrait
     */
    public function setChannel($channel)
    {
        $this->channel = $channel;
        return $this;
    }

    /**
     * @return int
     */
    public function getAgency()
    {
        return $this->agency;
    }

    /**
     * @param int $agency Insert the generic Agency Model here!
     * @return BookingChannelTrait
     */
    public function setAgency($agency)
    {
        $this->agency = $agency;
        return $this;
    }

    /**
     * @return int
     */
    public function getDepartment()
    {
        return $this->department;
    }

    /**
     * @param int $department
     * @return BookingChannelTrait
     */
    public function setDepartment($department)
    {
        $this->department = $department;
        return $this;
    }

}
