<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Handling;

/**
 * Class HandlingTrait
 * @package Vtours\Model\Booking\Handling
 */
trait HandlingTrait
{
    /**
     * @var string
     */
    private $type;

    /**
     * @var string
     */
    private $agency;

    /**
     * @var double
     */
    private $totalPrice;
    /**
     * @var double
     */
    private $vmixPriceAmount;

    /**
     * @var double
     */
    private $vmixSliceAmount;

    /**
     * @var double
     */
    private $actualPriceAmount;

    /**
     * @var \DateTime
     */
    private $actualPriceDate;

    /**
     * @var double
     */
    private $minimumRegulation;

    /**
     * @var string
     */
    private $invoiceNumber;

    /**
     * @var \DateTime
     */
    private $invoiceDate;

    /**
     * @var boolean
     */
    private $invoiceReviewed;

    /**
     * @var boolean
     */
    private $invoicePayed;

    /**
     * @var integer
     */
    private $creditorAccount;

    /**
     * @var \DateTime
     */
    private $dueDate;

    /**
     * @var string
     */
    private $currency;

    /**
     * @var double
     */
    private $exchangeRate;

    /**
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return HandlingTrait
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return string
     */
    public function getAgency()
    {
        return $this->agency;
    }

    /**
     * @param string $agency
     * @return HandlingTrait
     */
    public function setAgency($agency)
    {
        $this->agency = $agency;
        return $this;
    }

    /**
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->totalPrice;
    }

    /**
     * @param float $totalPrice
     * @return HandlingTrait
     */
    public function setTotalPrice($totalPrice)
    {
        $this->totalPrice = $totalPrice;
        return $this;
    }

    /**
     * @return float
     */
    public function getVmixPriceAmount()
    {
        return $this->vmixPriceAmount;
    }

    /**
     * @param float $vmixPriceAmount
     * @return HandlingTrait
     */
    public function setVmixPriceAmount($vmixPriceAmount)
    {
        $this->vmixPriceAmount = $vmixPriceAmount;
        return $this;
    }

    /**
     * @return float
     */
    public function getVmixSliceAmount()
    {
        return $this->vmixSliceAmount;
    }

    /**
     * @param float $vmixSliceAmount
     * @return HandlingTrait
     */
    public function setVmixSliceAmount($vmixSliceAmount)
    {
        $this->vmixSliceAmount = $vmixSliceAmount;
        return $this;
    }

    /**
     * @return float
     */
    public function getActualPriceAmount()
    {
        return $this->actualPriceAmount;
    }

    /**
     * @param float $actualPriceAmount
     * @return HandlingTrait
     */
    public function setActualPriceAmount($actualPriceAmount)
    {
        $this->actualPriceAmount = $actualPriceAmount;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getActualPriceDate()
    {
        return $this->actualPriceDate;
    }

    /**
     * @param \DateTime $actualPriceDate
     * @return HandlingTrait
     */
    public function setActualPriceDate($actualPriceDate)
    {
        $this->actualPriceDate = $actualPriceDate;
        return $this;
    }

    /**
     * @return float
     */
    public function getMinimumRegulation()
    {
        return $this->minimumRegulation;
    }

    /**
     * @param float $minimumRegulation
     * @return HandlingTrait
     */
    public function setMinimumRegulation($minimumRegulation)
    {
        $this->minimumRegulation = $minimumRegulation;
        return $this;
    }

    /**
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }

    /**
     * @param string $invoiceNumber
     * @return HandlingTrait
     */
    public function setInvoiceNumber($invoiceNumber)
    {
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }

    /**
     * @param \DateTime $invoiceDate
     * @return HandlingTrait
     */
    public function setInvoiceDate($invoiceDate)
    {
        $this->invoiceDate = $invoiceDate;
        return $this;
    }

    /**
     * @return bool
     */
    public function isInvoiceReviewed()
    {
        return $this->invoiceReviewed;
    }

    /**
     * @param bool $invoiceReviewed
     * @return HandlingTrait
     */
    public function setInvoiceReviewed($invoiceReviewed)
    {
        $this->invoiceReviewed = $invoiceReviewed;
        return $this;
    }

    /**
     * @return bool
     */
    public function isInvoicePayed()
    {
        return $this->invoicePayed;
    }

    /**
     * @param bool $invoicePayed
     * @return HandlingTrait
     */
    public function setInvoicePayed($invoicePayed)
    {
        $this->invoicePayed = $invoicePayed;
        return $this;
    }

    /**
     * @return integer
     */
    public function getCreditorAccount()
    {
        return $this->creditorAccount;
    }

    /**
     * @param integer $creditorAccount
     * @return HandlingTrait
     */
    public function setCreditorAccount($creditorAccount)
    {
        $this->creditorAccount = $creditorAccount;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }

    /**
     * @param \DateTime $dueDate
     * @return HandlingTrait
     */
    public function setDueDate($dueDate)
    {
        $this->dueDate = $dueDate;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return HandlingTrait
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return float
     */
    public function getExchangeRate()
    {
        return $this->exchangeRate;
    }

    /**
     * @param float $exchangeRate
     * @return HandlingTrait
     */
    public function setExchangeRate($exchangeRate)
    {
        $this->exchangeRate = $exchangeRate;
        return $this;
    }


}
