<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Participant;

use JMS\Serializer\Annotation as Serializer;

/**
 * Participant ParticipantTrait
 * @package Vtours\Model\Booking
 */
trait ParticipantTrait
{
    /**
     * @var integer
     * @Serializer\Type("integer")
     */
    private $number;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $salutation;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $firstName;

    /**
     * @var string
     * @Serializer\Type("string")
     */
    private $lastName;

    /**
     * @var integer
     * @Serializer\Type("integer")
     */
    private $age;

    /**
     * @var double
     * @Serializer\Type("double")
     */
    private $hotelPrice;

    /**
     * @var double
     * @Serializer\Type("double")
     */
    private $flightPrice;

    /**
     * @var \DateTime
     * @Serializer\Type("DateTime<'Y-m-d\TH:i:sP'>")
     */
    private $lastUpdate;

    /**
     * @var boolean
     * @Serializer\Type("boolean")
     */
    private $handicapped;

    /**
     * @var boolean
     * @Serializer\Type("boolean")
     */
    private $pregnant;

    /**
     * @var boolean
     * @Serializer\Type("boolean")
     */
    private $medicalCareNeeded;

    /**
     * @return integer
     */
    public function getNumber()
    {
        return $this->number;
    }

    /**
     * @param integer $number
     * @return ParticipantTrait
     */
    public function setNumber($number)
    {
        $this->number = $number;
        return $this;
    }

    /**
     * @return string
     */
    public function getSalutation()
    {
        return $this->salutation;
    }

    /**
     * @param string $salutation
     * @return ParticipantTrait
     */
    public function setSalutation($salutation)
    {
        $this->salutation = $salutation;
        return $this;
    }

    /**
     * @return string
     */
    public function getFirstName()
    {
        return $this->firstName;
    }

    /**
     * @param string $firstName
     * @return ParticipantTrait
     */
    public function setFirstName($firstName)
    {
        $this->firstName = $firstName;
        return $this;
    }

    /**
     * @return string
     */
    public function getLastName()
    {
        return $this->lastName;
    }

    /**
     * @param string $lastName
     * @return ParticipantTrait
     */
    public function setLastName($lastName)
    {
        $this->lastName = $lastName;
        return $this;
    }

    /**
     * @return integer
     */
    public function getAge()
    {
        return $this->age;
    }

    /**
     * @param integer $age
     * @return ParticipantTrait
     */
    public function setAge($age)
    {
        $this->age = $age;
        return $this;
    }

    /**
     * @return float
     */
    public function getHotelPrice()
    {
        return $this->hotelPrice;
    }

    /**
     * @param float $hotelPrice
     * @return ParticipantTrait
     */
    public function setHotelPrice($hotelPrice)
    {
        $this->hotelPrice = $hotelPrice;
        return $this;
    }

    /**
     * @return float
     */
    public function getFlightPrice()
    {
        return $this->flightPrice;
    }

    /**
     * @param float $flightPrice
     * @return ParticipantTrait
     */
    public function setFlightPrice($flightPrice)
    {
        $this->flightPrice = $flightPrice;
        return $this;
    }

    /**
     * @return \DateTime
     */
    public function getLastUpdate()
    {
        return $this->lastUpdate;
    }

    /**
     * @param \DateTime $lastUpdate
     * @return ParticipantTrait
     */
    public function setLastUpdate($lastUpdate)
    {
        $this->lastUpdate = $lastUpdate;
        return $this;
    }

    /**
     * @return bool
     */
    public function isHandicapped()
    {
        return $this->handicapped;
    }

    /**
     * @param bool $handicapped
     * @return ParticipantTrait
     */
    public function setHandicapped($handicapped)
    {
        $this->handicapped = $handicapped;
        return $this;
    }

    /**
     * @return bool
     */
    public function isPregnant()
    {
        return $this->pregnant;
    }

    /**
     * @param bool $pregnant
     * @return ParticipantTrait
     */
    public function setPregnant($pregnant)
    {
        $this->pregnant = $pregnant;
        return $this;
    }

    /**
     * @return bool
     */
    public function isMedicalCareNeeded()
    {
        return $this->medicalCareNeeded;
    }

    /**
     * @param bool $medicalCareNeeded
     * @return ParticipantTrait
     */
    public function setMedicalCareNeeded($medicalCareNeeded)
    {
        $this->medicalCareNeeded = $medicalCareNeeded;
        return $this;
    }

}
