<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Participant;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Participants
 * @package Vtours\Model\Booking\Participant
 */
class Participants
{
    /**
     * @var Participant[]
     * @Serializer\SerializedName("participants")
     */
    private $participants;

    /**
     * @return Participant[]
     */
    public function getParticipants()
    {
        return $this->participants;
    }

    /**
     * @param Participant $participant
     * @return Participants
     */
    public function addParticipant(Participant $participant)
    {
        $this->participants[] = $participant;
        return $this;
    }}
