<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Payment\BankAccount;

/**
 * Trait BankAccountTrait
 * @package Vtours\Model\Booking\Payments
 */
trait BankAccountTrait
{
    /**
     * @var string
     */
    private $accountHolder;

    /**
     * @var integer
     */
    private $accountNumber;

    /**
     * @var integer
     */
    private $bankSortCode;

    /**
     * @var string
     */
    private $iban;

    /**
     * @var string
     */
    private $bic;

    /**
     * @return string
     */
    public function getAccountHolder()
    {
        return $this->accountHolder;
    }

    /**
     * @param string $accountHolder
     * @return BankAccountTrait
     */
    public function setAccountHolder($accountHolder)
    {
        $this->accountHolder = $accountHolder;
        return $this;
    }

    /**
     * @return integer
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }

    /**
     * @param integer $accountNumber
     * @return BankAccountTrait
     */
    public function setAccountNumber($accountNumber)
    {
        $this->accountNumber = $accountNumber;
        return $this;
    }

    /**
     * @return integer
     */
    public function getBankSortCode()
    {
        return $this->bankSortCode;
    }

    /**
     * @param integer $bankSortCode
     * @return BankAccountTrait
     */
    public function setBankSortCode($bankSortCode)
    {
        $this->bankSortCode = $bankSortCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getIban()
    {
        return $this->iban;
    }

    /**
     * @param string $iban
     * @return BankAccountTrait
     */
    public function setIban($iban)
    {
        $this->iban = $iban;
        return $this;
    }

    /**
     * @return string
     */
    public function getBic()
    {
        return $this->bic;
    }

    /**
     * @param string $bic
     * @return BankAccountTrait
     */
    public function setBic($bic)
    {
        $this->bic = $bic;
        return $this;
    }
}
