<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Payment;
/**
 * Trait PaymentBaseDataTrait
 * @package Vtours\Model\Booking\Payments
 */
trait PaymentBaseDataTrait
{
    /**
     * @var string
     */
    private $paymentMethod;

    /**
     * @var double
     */
    private $totalPriceGross;

    /**
     * @var double
     */
    private $totalPriceNet;

    /**
     * @var string
     */
    private $currency;

    /**
     * @var double
     */
    private $serviceCharge;

    /**
     * @var double
     */
    private $resellerCommission;

    /**
     * @var double
     */
    private $tourOperatorCommission;

    /**
     * @var double
     */
    private $tourOperatorMargin;

    /**
     * @var double
     */
    private $flightPriceGross;

    /**
     * @var double
     */
    private $flightPriceMargin;

    /**
     * @var double
     */
    private $bookingPriceMarginGross;

    /**
     * @var double
     */
    private $bookingPriceMarginNet;

    /**
     * @var string
     */
    private $calculatedBy;

    /**
     * @var double
     */
    private $organizerLiability;

    /**
     * @var double
     */
    private $inabilityInsurance;

    /**
     * @var string
     */
    private $marginTaxLiability;

    /**
     * @var double
     */
    private $bookingTax;

    /**
     * @var double
     */
    private $channelTax;

    /**
     * @var double
     */
    private $resortFeeAmount;

    /**
     * @var double
     */
    private $resortFeeOriginal;

    /**
     * @var string
     */
    private $resortFeeCurrency;

    /**
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }

    /**
     * @param string $paymentMethod
     * @return PaymentBaseDataTrait
     */
    public function setPaymentMethod($paymentMethod)
    {
        $this->paymentMethod = $paymentMethod;
        return $this;
    }

    /**
     * @return float
     */
    public function getTotalPriceGross()
    {
        return $this->totalPriceGross;
    }

    /**
     * @param float $totalPriceGross
     * @return PaymentBaseDataTrait
     */
    public function setTotalPriceGross($totalPriceGross)
    {
        $this->totalPriceGross = $totalPriceGross;
        return $this;
    }

    /**
     * @return float
     */
    public function getTotalPriceNet()
    {
        return $this->totalPriceNet;
    }

    /**
     * @param float $totalPriceNet
     * @return PaymentBaseDataTrait
     */
    public function setTotalPriceNet($totalPriceNet)
    {
        $this->totalPriceNet = $totalPriceNet;
        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return PaymentBaseDataTrait
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
        return $this;
    }

    /**
     * @return float
     */
    public function getServiceCharge()
    {
        return $this->serviceCharge;
    }

    /**
     * @param float $serviceCharge
     * @return PaymentBaseDataTrait
     */
    public function setServiceCharge($serviceCharge)
    {
        $this->serviceCharge = $serviceCharge;
        return $this;
    }

    /**
     * @return float
     */
    public function getResellerCommission()
    {
        return $this->resellerCommission;
    }

    /**
     * @param float $resellerCommission
     * @return PaymentBaseDataTrait
     */
    public function setResellerCommission($resellerCommission)
    {
        $this->resellerCommission = $resellerCommission;
        return $this;
    }

    /**
     * @return float
     */
    public function getTourOperatorCommission()
    {
        return $this->tourOperatorCommission;
    }

    /**
     * @param float $tourOperatorCommission
     * @return PaymentBaseDataTrait
     */
    public function setTourOperatorCommission($tourOperatorCommission)
    {
        $this->tourOperatorCommission = $tourOperatorCommission;
        return $this;
    }

    /**
     * @return float
     */
    public function getTourOperatorMargin()
    {
        return $this->tourOperatorMargin;
    }

    /**
     * @param float $tourOperatorMargin
     * @return PaymentBaseDataTrait
     */
    public function setTourOperatorMargin($tourOperatorMargin)
    {
        $this->tourOperatorMargin = $tourOperatorMargin;
        return $this;
    }

    /**
     * @return float
     */
    public function getFlightPriceGross()
    {
        return $this->flightPriceGross;
    }

    /**
     * @param float $flightPriceGross
     * @return PaymentBaseDataTrait
     */
    public function setFlightPriceGross($flightPriceGross)
    {
        $this->flightPriceGross = $flightPriceGross;
        return $this;
    }

    /**
     * @return float
     */
    public function getFlightPriceMargin()
    {
        return $this->flightPriceMargin;
    }

    /**
     * @param float $flightPriceMargin
     * @return PaymentBaseDataTrait
     */
    public function setFlightPriceMargin($flightPriceMargin)
    {
        $this->flightPriceMargin = $flightPriceMargin;
        return $this;
    }

    /**
     * @return float
     */
    public function getBookingPriceMarginGross()
    {
        return $this->bookingPriceMarginGross;
    }

    /**
     * @param float $bookingPriceMarginGross
     * @return PaymentBaseDataTrait
     */
    public function setBookingPriceMarginGross($bookingPriceMarginGross)
    {
        $this->bookingPriceMarginGross = $bookingPriceMarginGross;
        return $this;
    }

    /**
     * @return float
     */
    public function getBookingPriceMarginNet()
    {
        return $this->bookingPriceMarginNet;
    }

    /**
     * @param float $bookingPriceMarginNet
     * @return PaymentBaseDataTrait
     */
    public function setBookingPriceMarginNet($bookingPriceMarginNet)
    {
        $this->bookingPriceMarginNet = $bookingPriceMarginNet;
        return $this;
    }

    /**
     * @return string
     */
    public function getCalculatedBy()
    {
        return $this->calculatedBy;
    }

    /**
     * @param string $calculatedBy
     * @return PaymentBaseDataTrait
     */
    public function setCalculatedBy($calculatedBy)
    {
        $this->calculatedBy = $calculatedBy;
        return $this;
    }

    /**
     * @return float
     */
    public function getOrganizerLiability()
    {
        return $this->organizerLiability;
    }

    /**
     * @param float $organizerLiability
     * @return PaymentBaseDataTrait
     */
    public function setOrganizerLiability($organizerLiability)
    {
        $this->organizerLiability = $organizerLiability;
        return $this;
    }

    /**
     * @return float
     */
    public function getInabilityInsurance()
    {
        return $this->inabilityInsurance;
    }

    /**
     * @param float $inabilityInsurance
     * @return PaymentBaseDataTrait
     */
    public function setInabilityInsurance($inabilityInsurance)
    {
        $this->inabilityInsurance = $inabilityInsurance;
        return $this;
    }

    /**
     * @return string
     */
    public function getMarginTaxLiability()
    {
        return $this->marginTaxLiability;
    }

    /**
     * @param string $marginTaxLiability
     * @return PaymentBaseDataTrait
     */
    public function setMarginTaxLiability($marginTaxLiability)
    {
        $this->marginTaxLiability = $marginTaxLiability;
        return $this;
    }

    /**
     * @return float
     */
    public function getBookingTax()
    {
        return $this->bookingTax;
    }

    /**
     * @param float $bookingTax
     * @return PaymentBaseDataTrait
     */
    public function setBookingTax($bookingTax)
    {
        $this->bookingTax = $bookingTax;
        return $this;
    }

    /**
     * @return float
     */
    public function getChannelTax()
    {
        return $this->channelTax;
    }

    /**
     * @param float $channelTax
     * @return PaymentBaseDataTrait
     */
    public function setChannelTax($channelTax)
    {
        $this->channelTax = $channelTax;
        return $this;
    }

    /**
     * @return float
     */
    public function getResortFeeAmount()
    {
        return $this->resortFeeAmount;
    }

    /**
     * @param float $resortFeeAmount
     * @return PaymentBaseDataTrait
     */
    public function setResortFeeAmount($resortFeeAmount)
    {
        $this->resortFeeAmount = $resortFeeAmount;
        return $this;
    }

    /**
     * @return float
     */
    public function getResortFeeOriginal()
    {
        return $this->resortFeeOriginal;
    }

    /**
     * @param float $resortFeeOriginal
     * @return PaymentBaseDataTrait
     */
    public function setResortFeeOriginal($resortFeeOriginal)
    {
        $this->resortFeeOriginal = $resortFeeOriginal;
        return $this;
    }

    /**
     * @return string
     */
    public function getResortFeeCurrency()
    {
        return $this->resortFeeCurrency;
    }

    /**
     * @param string $resortFeeCurrency
     * @return PaymentBaseDataTrait
     */
    public function setResortFeeCurrency($resortFeeCurrency)
    {
        $this->resortFeeCurrency = $resortFeeCurrency;
        return $this;
    }

}
