<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Payment\Wirecard;

/**
 * Trait WirecardTrait
 * @package Vtours\Model\Booking\Payments
 */
trait WirecardTrait
{
    /**
     * @var string
     */
    private $prePaymentToken;

    /**
     * @var string
     */
    private $balancePaymentToken;

    /**
     * @var string
     */
    private $cancellationToken;

    /**
     * @return string
     */
    public function getPrePaymentToken()
    {
        return $this->prePaymentToken;
    }

    /**
     * @param string $prePaymentToken
     * @return WirecardTrait
     */
    public function setPrePaymentToken($prePaymentToken)
    {
        $this->prePaymentToken = $prePaymentToken;
        return $this;
    }

    /**
     * @return string
     */
    public function getBalancePaymentToken()
    {
        return $this->balancePaymentToken;
    }

    /**
     * @param string $balancePaymentToken
     * @return WirecardTrait
     */
    public function setBalancePaymentToken($balancePaymentToken)
    {
        $this->balancePaymentToken = $balancePaymentToken;
        return $this;
    }

    /**
     * @return string
     */
    public function getCancellationToken()
    {
        return $this->cancellationToken;
    }

    /**
     * @param string $cancellationToken
     * @return WirecardTrait
     */
    public function setCancellationToken($cancellationToken)
    {
        $this->cancellationToken = $cancellationToken;
        return $this;
    }
}
