<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Test;

use PHPUnit\Framework\TestCase;
use Vtours\Model\Booking\Booking;

/**
 * Class BookingTest
 * @package Vtours\Model\Booking\Test
 */
class BookingTest extends TestCase
{
    public function test_add_participants()
    {
        $booking = new Booking();
        $booking
            ->setClient('VTO')
            ->setCancelled(1);

        self::assertInstanceOf(Booking::class, $booking);
        self::assertSame('VTO', $booking->getClient());
    }
}
