<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Test;
use PHPUnit\Framework\TestCase;
use Vtours\Model\Booking\Booking;
use Vtours\Model\Booking\Customer\Customer;

/**
 * Class CustomerTest
 * @package ${NAMESPACE}
 */
class CustomerTest extends TestCase
{
    public function test_add_customer_to_booking_model()
    {
        $customer = new Customer();
        $customer
            ->setFirstName('Dennis')
            ->setLastName('Barlowe')
            ->setEmail('d.barlowe@life-style.de')
            ->setCity('Aschaffenburg')
            ->setRemarks('is a cool dude')
        ;

        $booking = new Booking();
        $booking->setCustomer($customer);

        self::assertSame('Barlowe', $booking->getCustomer()->getLastName());
        self::assertInstanceOf(Customer::class, $booking->getCustomer());
    }
}
