<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is private by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license
 *  is a violation of the license agreement and will be prosecuted by
 *  civil and criminal law.
 *
 * @copyright 2019 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\Model\Booking\Test;

use PHPUnit\Framework\TestCase;
use Vtours\Model\Booking\Booking;
use Vtours\Model\Booking\TravelApplicant\TravelApplicant;

/**
 * Class TravelApplicantTest
 * @package Vtours\Model\Booking\Test
 */
class TravelApplicantTest extends TestCase
{
    public function test_add_travel_applicant_to_booking_model()
    {
        $travelApplicant = new TravelApplicant();
        $travelApplicant
            ->setFirstName('Dennis')
            ->setLastName('Barlowe')
            ;

        $booking = new Booking();
        $booking->setTravelApplicant($travelApplicant);

        self::assertInstanceOf(TravelApplicant::class, $booking->getTravelApplicant());
        self::assertSame('Barlowe', $booking->getTravelApplicant()->getLastName());
    }
}
