<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg,Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdkBundle\DependencyInjection;

use Exception;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Vtours\ComputopPaymentSdk\Service\CreditCard\CreditCardInitialPaymentService;
use Vtours\ComputopPaymentSdk\Service\CreditCard\CreditCardRecurringPaymentService;
use Vtours\ComputopPaymentSdk\Service\DirectDebit\DirectDebitInitialPaymentService;
use Vtours\ComputopPaymentSdk\Service\DirectDebit\DirectDebitRecurringPaymentService;

/**
 * Class LifeStyleProtocolServiceSdkExtension
 * @package LifeStyle\ProtocolServiceSdkBundle\DependencyInjection
 */
class ComputopPaymentServiceSdkExtension extends Extension
{
    /**
     * @inheritDoc
     * @throws Exception
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configurationInstance = new ComputopPaymentServiceSdkConfiguration();
        $configuration = $this->processConfiguration($configurationInstance, $configs);

        $path = dirname(__DIR__) . '/Resources/config';
        (new YamlFileLoader($container, new FileLocator($path)))
            ->load('services.yaml');

        $this->process($configuration, $container);
    }

    /**
     * @param array $configuration
     * @param ContainerBuilder $container
     */
    public function process(array $configuration, ContainerBuilder $container)
    {
        if ($container->has(DirectDebitInitialPaymentService::class)) {
            $directDebitInitialDefinition = $container->findDefinition(DirectDebitInitialPaymentService::class);
            $directDebitInitialDefinition->setArgument(0, $configuration['base_uri']);
            $directDebitInitialDefinition->setArgument(1, $configuration['timeout']);
            $directDebitInitialDefinition->setArgument(2, $configuration['debug']);
        }

        if ($container->has(DirectDebitRecurringPaymentService::class)) {
            $directDebitRecurringDefinition = $container->findDefinition(DirectDebitRecurringPaymentService::class);
            $directDebitRecurringDefinition->setArgument(0, $configuration['base_uri']);
            $directDebitRecurringDefinition->setArgument(1, $configuration['timeout']);
            $directDebitRecurringDefinition->setArgument(2, $configuration['debug']);
        }

        if ($container->has(CreditCardInitialPaymentService::class)) {
            $creditCardInitialDefinition = $container->findDefinition(CreditCardInitialPaymentService::class);
            $creditCardInitialDefinition->setArgument(0, $configuration['base_uri']);
            $creditCardInitialDefinition->setArgument(1, $configuration['timeout']);
            $creditCardInitialDefinition->setArgument(2, $configuration['debug']);
        }

        if ($container->has(CreditCardRecurringPaymentService::class)) {
            $creditCardRecurringDefinition = $container->findDefinition(CreditCardRecurringPaymentService::class);
            $creditCardRecurringDefinition->setArgument(0, $configuration['base_uri']);
            $creditCardRecurringDefinition->setArgument(1, $configuration['timeout']);
            $creditCardRecurringDefinition->setArgument(2, $configuration['debug']);
        }

    }
}
