<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

require_once ('vendor/autoload.php');

$request = new \Vtours\ComputopPaymentSdk\Model\InitialPayment\Request();

$request
    ->setAmount(1)
    ->setCurrency('EUR')
    ->setAccountOwner('John Doe')
    ->setIban('DE12500105170648489890')
    ->setBankName('ING')
    ->setMandateId('dasdasfasf')
    ->setDateOfSignature(new DateTime('-3 days'))
    ->setOrderDescription('blabla')
    ->setTransactionId('123456-vtours-15');

$service = new \Vtours\ComputopPaymentSdk\Service\ComputopPaymentService(
    'http://localhost:8090/'
);

$res = $service->payAsInitialPayment($request);
var_dump($res);