<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Service;

use Exception;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use Vtours\ComputopPaymentSdk\Exception\ComputopPaymentServiceException;
use Vtours\ComputopPaymentSdk\Mapper\ResponseMapper;
use Vtours\ComputopPaymentSdk\Model\InitialPayment\Request as InitialPaymentRequest;
use function GuzzleHttp\Psr7\str;

/**
 * Class ComputopPaymentService
 * @package Vtours\ComputopPaymentSdk\Service
 */
class ComputopPaymentService
{
    /**
     * URL for the Computop Payment Service.
     *
     * @var string
     */
    private $url;

    /**
     * @var Client
     */
    private $client;

    /**
     * @var ResponseMapper
     */
    private $responseMapper;

    /**
     * ComputopPaymentService constructor.
     * @param $url
     */
    public function __construct($url)
    {
        $this->url = $url;
        $this->client = new Client([
            'base_uri' => $url,
            'timeout' => 60,
        ]);
        $this->responseMapper = new ResponseMapper();
    }

    /**
     * @param InitialPaymentRequest $request
     * @return string
     * @throws ComputopPaymentServiceException
     */
    public function payAsInitialPayment(InitialPaymentRequest $request)
    {
        try {
            $response = $this->client->request('POST', '/direct-debit/initial', [
                'json' => $request,
                'debug' => true,
            ]);
        } catch (GuzzleException $exception) {
            throw new ComputopPaymentServiceException('There has been a problem. ', 500, $exception);
        }

        $responseBody = (string)$response->getBody();

        return $this->responseMapper->map(json_decode($responseBody, true));
    }

    public function payAsRecurringPayment()
    {

    }


}
