<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

require_once ('vendor/autoload.php');

$service = new \Vtours\ComputopPaymentSdk\Service\ComputopSepaPaymentService(
    'http://localhost:8090/'
);

$request = new \Vtours\ComputopPaymentSdk\Model\InitialPayment\Request();
$request
    ->setAmount(1)
    ->setCurrency('EUR')
    ->setAccountOwner('John Doe')
    ->setIban('DE12500105170648489890')
    ->setBankName('ING')
    ->setMandateId('dasdasfasf')
    ->setDateOfSignature(new DateTime('-3 days'))
    ->setOrderDescription('blabla')
    ->setTransactionId('123456-vtours-15');

$res = $service->payAsInitialPayment($request);
//var_dump($res);



$recurringRequest = new \Vtours\ComputopPaymentSdk\Model\RecurringPayment\Request();
$recurringRequest
    ->setAmount(5)
    ->setOrderDescription('TEST')
    ->setCurrency('EUR')
    ->setPaymentId('dfe6c9c8a9744e2591c20a476e592254');

$result = $service->payAsRecurringPayment($recurringRequest);
//var_dump($result);