<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Mapper\DirectDebit;

use DateTime;
use Psr\Http\Message\ResponseInterface;
use Vtours\ComputopPaymentSdk\Mapper\ResponseMapperAbstract;
use Vtours\ComputopPaymentSdk\Model\InitialPayment\Request;
use Vtours\ComputopPaymentSdk\Model\Response;

/**
 * Class ResponseMapper
 * @package Vtours\ComputopPaymentSdk\Mapper
 */
class DirectDebitMapperInitial extends ResponseMapperAbstract
{

    /**
     * @param ResponseInterface $response
     * @return Response
     */
    public function map(ResponseInterface $response): Response
    {
        $responseBody = $this->getResponseBody($response);

        return (new Response())
            ->setStatus($responseBody['status'])
            ->setStatusCode($responseBody['status_code'])
            ->setMessage($responseBody['message'])
            ->setRequestData($this->mapRequestData($response))
            ->setResponseData($this->mapResponse($response));
    }

    protected function mapRequestData(ResponseInterface $response): Request
    {
        $responseBody = $this->getResponseBody($response);

        return (new Request())
            ->setAmount($responseBody['request_data']['amount'] ?? null)
            ->setCurrency($responseBody['request_data']['currency'] ?? null)
            ->setAccountOwner($responseBody['request_data']['account_owner'] ?? null)
            ->setIban($responseBody['request_data']['iban'] ?? null)
            ->setBankName($responseBody['request_data']['bank_name'] ?? null)
            ->setOrderDescription($responseBody['request_data']['order_description'] ?? null)
            ->setDateOfSignature(DateTime::createFromFormat('d.m.Y', $responseBody['request_data']['date_of_signature'] ?? null))
            ->setMandateId($responseBody['request_data']['mandate_id'] ?? null)
            ->setTransactionId($responseBody['request_data']['transaction_id'] ?? null);
    }

}
