<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Mapper\DirectDebit;

use Psr\Http\Message\ResponseInterface;
use Vtours\ComputopPaymentSdk\Mapper\ResponseMapperAbstract;
use Vtours\ComputopPaymentSdk\Model\RecurringPayment\Request;
use Vtours\ComputopPaymentSdk\Model\Response;

/**
 * Class ResponseMapper
 * @package Vtours\ComputopPaymentSdk\Mapper
 */
class DirectDebitMapperRecurring extends ResponseMapperAbstract
{

    /**
     * @param ResponseInterface $response
     * @return Response
     */
    public function map(ResponseInterface $response): Response
    {
        $responseBody = $this->getResponseBody($response);

        return (new Response())
            ->setStatus($responseBody['status'])
            ->setStatusCode($responseBody['status_code'])
            ->setMessage($responseBody['message'])
            ->setRequestData($this->mapRequestData($response))
            ->setResponseData($this->mapResponse($response));
    }

    protected function mapRequestData(ResponseInterface $response): Request
    {
        $responseBody = $this->getResponseBody($response);

        return (new Request())
            ->setAmount($responseBody['request_data']['amount'] ?? null)
            ->setCurrency($responseBody['request_data']['currency'] ?? null)
            ->setOrderDescription($responseBody['request_data']['order_description'] ?? null)
            ->setPaymentId($responseBody['request_data']['payment_id'] ?? null);
    }

}
