<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Mapper;

use DateTime;
use Psr\Http\Message\ResponseInterface;
use Vtours\ComputopPaymentSdk\Model\InitialPayment\ResponseData;
use Vtours\ComputopPaymentSdk\Model\RequestInterface;
use Vtours\ComputopPaymentSdk\Model\Response;
use Vtours\ComputopPaymentSdk\Model\ResponseDataInterface;

/**
 * Class ResponseMapperInterface
 * @package Vtours\ComputopPaymentSdk\Mapper
 */
abstract class ResponseMapperAbstract implements ResponseMapperInterface
{
    /**
     * @param ResponseInterface $response
     * @return RequestInterface
     */
    abstract protected function mapRequestData(ResponseInterface $response);

    /**
     * @param ResponseInterface $response
     * @return Response
     */
    abstract public function map(ResponseInterface $response): Response;

    /**
     * @param ResponseInterface $response
     * @return array
     */
    protected function getResponseBody(ResponseInterface $response): array
    {
        $responseBody = (string)$response->getBody();

        return json_decode($responseBody, true);
    }

    /**
     * @param ResponseInterface $response
     * @return ResponseDataInterface
     */
    protected function mapResponse(ResponseInterface $response)
    {
        $responseBody = $this->getResponseBody($response);

        return (new ResponseData())
            ->setMid($responseBody['response_data']['mid'] ?? null)
            ->setPaymentId($responseBody['response_data']['PayID'] ?? null)
            ->setXid($responseBody['response_data']['XID'] ?? null)
            ->setTransactionId($responseBody['response_data']['TransID'] ?? null)
            ->setIban($responseBody['response_data']['IBAN'] ?? null)
            ->setAccountOwner($responseBody['response_data']['AccOwner'] ?? null)
            ->setBankName($responseBody['response_data']['AccBank'] ?? null)
            ->setMandateId($responseBody['response_data']['mandateid'] ?? null)
            ->setDateOfSignature(DateTime::createFromFormat('d.m.Y', $responseBody['response_data']['dtofsgntr'] ?? null))
            ->setMandateSequenceType($responseBody['response_data']['mdtseqtype'] ?? null)
            ->setStatus($responseBody['response_data']['Status'] ?? null)
            ->setCode($responseBody['response_data']['Code'] ?? null)
            ->setPaymentId($responseBody['response_data']['PayID'])
            ->setDescription($responseBody['response_data']['Description'] ?? null);
    }

}
