<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Model;

/**
 * Class Response
 * @package Vtours\ComputopPaymentSdk\Model\InitialPayment
 */
class Response
{
    /**
     * @var integer
     */
    private $statusCode;

    /**
     * @var string
     */
    private $status;

    /**
     * @var string
     */
    private $message;

    /**
     * @var RequestInterface
     */
    private $requestData;

    /**
     * @var ResponseDataInterface
     */
    private $responseData;

    /**
     * @return int
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }

    /**
     * @param int $statusCode
     * @return Response
     */
    public function setStatusCode($statusCode)
    {
        $this->statusCode = $statusCode;
        return $this;
    }

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @param string $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return Response
     */
    public function setMessage($message)
    {
        $this->message = $message;
        return $this;
    }

    /**
     * @return RequestInterface
     */
    public function getRequestData(): RequestInterface
    {
        return $this->requestData;
    }

    /**
     * @param RequestInterface $requestData
     * @return Response
     */
    public function setRequestData(RequestInterface $requestData): Response
    {
        $this->requestData = $requestData;
        return $this;
    }

    /**
     * @return ResponseDataInterface
     */
    public function getResponseData(): ResponseDataInterface
    {
        return $this->responseData;
    }

    /**
     * @param ResponseDataInterface $responseData
     * @return Response
     */
    public function setResponseData(ResponseDataInterface $responseData): Response
    {
        $this->responseData = $responseData;
        return $this;
    }
}
