<?php
/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Vtours\ComputopPaymentSdk\Mapper\DirectDebit;

use DateTime;
use Psr\Http\Message\ResponseInterface as HttpResponseInterface;
use Vtours\ComputopPaymentSdk\Mapper\ResponseMapperAbstract;
use Vtours\ComputopPaymentSdk\Model\RecurringPayment\Request as RequestRecurring;
use Vtours\ComputopPaymentSdk\Model\RecurringPayment\Response as ResponseRecurring;
use Vtours\ComputopPaymentSdk\Model\RequestInterface;
use Vtours\ComputopPaymentSdk\Model\Response;
use Vtours\ComputopPaymentSdk\Model\ResponseInterface;

/**
 * Class DirectDebitMapperRecurring
 * @package Vtours\ComputopPaymentSdk\Mapper\DirectDebit
 */
class DirectDebitMapperRecurring extends ResponseMapperAbstract
{
    /**
     * @param HttpResponseInterface $response
     * @return Response
     */
    public function map(HttpResponseInterface $response): Response
    {
        $responseBody = $this->getResponseBody($response);

        return (new Response())
            ->setStatus($responseBody['status'])
            ->setStatusCode($responseBody['status_code'])
            ->setMessage($responseBody['message'])
            ->setRequest($this->mapRequest($response))
            ->setResponse($this->mapResponse($response));
    }

    /**
     * @param HttpResponseInterface $response
     * @return RequestRecurring
     */
    protected function mapRequest(HttpResponseInterface $response): RequestInterface
    {
        $responseBody = $this->getResponseBody($response);

        return (new RequestRecurring())
            ->setAmount($responseBody['request_data']['amount'] ?? null)
            ->setCurrency($responseBody['request_data']['currency'] ?? null)
            ->setOrderDescription($responseBody['request_data']['order_description'] ?? null)
            ->setPaymentId($responseBody['request_data']['payment_id'] ?? null);
    }

    /**
     * @param HttpResponseInterface $response
     * @return ResponseRecurring
     */
    protected function mapResponse(HttpResponseInterface $response): ResponseInterface
    {
        $responseBody = $this->getResponseBody($response);

        return (new ResponseRecurring())
            ->setMid($responseBody['response_data']['mid'] ?? null)
            ->setPaymentId($responseBody['response_data']['PayID'] ?? null)
            ->setXid($responseBody['response_data']['XID'] ?? null)
            ->setTransactionId($responseBody['response_data']['TransID'] ?? null)
            ->setIban($responseBody['response_data']['IBAN'] ?? null)
            ->setAccountOwner($responseBody['response_data']['AccOwner'] ?? null)
            ->setBankName($responseBody['response_data']['AccBank'] ?? null)
            ->setMandateId($responseBody['response_data']['mandateid'] ?? null)
            ->setDateOfSignature(DateTime::createFromFormat('d.m.Y',
                $responseBody['response_data']['dtofsgntr'] ?? null))
            ->setMandateSequenceType($responseBody['response_data']['mdtseqtype'] ?? null)
            ->setStatus($responseBody['response_data']['Status'] ?? null)
            ->setCode($responseBody['response_data']['Code'] ?? null)
            ->setPaymentId($responseBody['response_data']['PayID'])
            ->setDescription($responseBody['response_data']['Description'] ?? null);
    }
}
